/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.virtualmouse.snapping;

import dev.isxander.controlify.api.vmousesnapping.ISnapBehaviour;
import dev.isxander.controlify.api.vmousesnapping.SnapPoint;
import dev.isxander.controlify.mixins.feature.virtualmouse.snapping.AbstractContainerScreenMixin;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.world.inventory.EnchantmentMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EnchantmentScreen.class})
public abstract class EnchantmentScreenMixin
extends AbstractContainerScreenMixin<EnchantmentMenu>
implements ISnapBehaviour {
    @Unique
    private static final int SLOT_AREA_OFFSET_X = 60;
    @Unique
    private static final int SLOT_AREA_OFFSET_Y = 14;
    @Unique
    private static final int SLOT_WIDTH = 108;
    @Unique
    private static final int SLOT_HEIGHT = 19;
    @Unique
    private static final int SLOT_VERTICAL_SPACING = 19;

    @Override
    public void controlify$collectSnapPoints(Consumer<SnapPoint> consumer) {
        super.controlify$collectSnapPoints(consumer);
        int leftPos = (this.width - this.imageWidth) / 2;
        int topPos = (this.height - this.imageHeight) / 2;
        int snapRadius = 14;
        for (int slotIndex = 0; slotIndex < 3; ++slotIndex) {
            if (((EnchantmentMenu)this.menu).costs[slotIndex] == 0) continue;
            int slotX = leftPos + 60;
            int slotY = topPos + 14 + slotIndex * 19;
            int centreSlotX = slotX + 54;
            int centreSlotY = slotY + 9;
            consumer.accept(new SnapPoint(centreSlotX, centreSlotY, snapRadius));
        }
    }
}

