/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.virtualmouse.snapping;

import dev.isxander.controlify.api.vmousesnapping.ISnapBehaviour;
import dev.isxander.controlify.api.vmousesnapping.SnapPoint;
import dev.isxander.controlify.mixins.feature.virtualmouse.snapping.AbstractContainerScreenMixin;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.world.inventory.StonecutterMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={StonecutterScreen.class})
public abstract class StonecutterScreenMixin
extends AbstractContainerScreenMixin<StonecutterMenu>
implements ISnapBehaviour {
    @Unique
    private static final int COLUMNS = 4;
    @Unique
    private static final int ROWS = 3;
    @Unique
    private static final int SLOTS = 12;
    @Unique
    private static final int BTN_WIDTH = 16;
    @Unique
    private static final int BTN_HEIGHT = 18;
    @Unique
    private static final int BTN_Y_PADDING = 2;
    @Shadow
    private int startIndex;

    @Override
    public void controlify$collectSnapPoints(Consumer<SnapPoint> consumer) {
        super.controlify$collectSnapPoints(consumer);
        int startIndex = this.startIndex;
        int endIndex = this.startIndex + 12;
        int visibleRecipes = ((StonecutterMenu)this.menu).getNumberOfVisibleRecipes();
        int gridLeft = this.leftPos + 52;
        int gridTop = this.topPos + 14;
        int halfWidth = 8;
        int halfHeight = 9;
        int snapRadius = halfHeight + 2;
        for (int absoluteIndex = startIndex; absoluteIndex < endIndex && absoluteIndex < visibleRecipes + startIndex; ++absoluteIndex) {
            int relativeIndex = absoluteIndex - startIndex;
            int column = relativeIndex % 4;
            int row = relativeIndex / 4;
            int posX = gridLeft + column * 16 + halfWidth;
            int posY = gridTop + row * 18 + 2 + halfHeight;
            consumer.accept(new SnapPoint(posX, posY, snapRadius));
        }
    }
}

