/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ComponentProcessorProvider;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.compat.vanilla.EditBoxComponentProcessor;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayouts;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;

public class AddServerLikeScreenProcessor
extends ScreenProcessor<Screen> {
    private final Supplier<EditBox> ipEditBoxSupplier;
    private final Supplier<Button> doneButtonSupplier;
    private final Supplier<Button> backButtonSupplier;

    public AddServerLikeScreenProcessor(Screen screen, Supplier<EditBox> ipEditBoxSupplier, Supplier<Button> doneButtonSupplier, Supplier<Button> backButtonSupplier) {
        super(screen);
        this.ipEditBoxSupplier = ipEditBoxSupplier;
        this.doneButtonSupplier = doneButtonSupplier;
        this.backButtonSupplier = backButtonSupplier;
    }

    @Override
    public void onWidgetRebuild() {
        super.onWidgetRebuild();
        EditBox ipEditBox = this.ipEditBoxSupplier.get();
        Button doneButton = this.doneButtonSupplier.get();
        Button backButton = this.backButtonSupplier.get();
        if (ipEditBox != null) {
            EditBoxComponentProcessor processor = (EditBoxComponentProcessor)ComponentProcessorProvider.provide((GuiEventListener)ipEditBox);
            processor.setKeyboardLayout(KeyboardLayouts.serverIp());
        }
        if (doneButton != null) {
            ButtonGuideApi.addGuideToButton(doneButton, () -> doneButton.isFocused() ? ControlifyBindings.GUI_PRESS : ControlifyBindings.GUI_ABSTRACT_ACTION_1, ButtonGuidePredicate.always());
        }
        if (backButton != null) {
            ButtonGuideApi.addGuideToButton(backButton, () -> ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always());
        }
    }

    @Override
    protected void handleButtons(ControllerEntity controller) {
        Button doneButton;
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_1.on(controller).guiPressed().get() && (doneButton = this.doneButtonSupplier.get()) != null && !doneButton.isFocused()) {
            AddServerLikeScreenProcessor.playClackSound();
            this.screen.setFocused((GuiEventListener)doneButton);
        }
        super.handleButtons(controller);
    }
}

