/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.LoggerFactory;

public class CUtil {
    public static final ControlifyLogger LOGGER = ControlifyLogger.createMasterLogger(LoggerFactory.getLogger((String)"Controlify"));
    public static final boolean IS_POJAV_LAUNCHER = System.getenv("POJAV_NATIVEDIR") != null;

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"controlify", (String)path);
    }

    public static BufferBuilder beginBuffer(VertexFormat.Mode mode, VertexFormat format) {
        return Tesselator.getInstance().begin(mode, format);
    }

    public static void openUri(String uri) {
        try {
            String[] command = URIOpener.get().openArguments(URI.create(uri));
            Process process = Runtime.getRuntime().exec(command);
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
        }
        catch (IOException | SecurityException e) {
            LOGGER.error("Failed to open URI: {}", uri, e);
        }
    }

    public static <T> Supplier<T> lazyInit(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private T created = null;

            @Override
            public T get() {
                if (this.created == null) {
                    this.created = supplier.get();
                }
                return this.created;
            }
        };
    }

    public static String createUIDFromBytes(byte[] ... bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not get MD5 hash.", e);
        }
        for (byte[] b : bytes) {
            md.update(b);
        }
        byte[] digest = md.digest();
        return Hex.encodeHexString((byte[])digest);
    }

    public static void sleepChecked(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to sleep for {}ms", e, millis);
        }
    }

    public static <E> Codec<E> stringResolver(Function<E, String> toString, Function<String, E> fromString) {
        return Codec.STRING.flatXmap(name -> Optional.ofNullable(fromString.apply((String)name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + name)), e -> Optional.ofNullable((String)toString.apply(e)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + String.valueOf(e))));
    }

    public static <T extends StringRepresentable> Function<String, T> createNameLookup(T[] values, Function<String, String> keyFunction) {
        Map<String, StringRepresentable> map = Arrays.stream(values).collect(Collectors.toMap(stringRepresentable -> (String)keyFunction.apply(stringRepresentable.getSerializedName()), stringRepresentable -> stringRepresentable));
        return string -> string == null ? null : (StringRepresentable)map.get(string);
    }

    public static <E> MapCodec<E> orCompressed(final MapCodec<E> first, final MapCodec<E> second) {
        return new MapCodec<E>(){

            public <T> RecordBuilder<T> encode(E object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                return dynamicOps.compressMaps() ? second.encode(object, dynamicOps, recordBuilder) : first.encode(object, dynamicOps, recordBuilder);
            }

            public <T> DataResult<E> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return dynamicOps.compressMaps() ? second.decode(dynamicOps, mapLike) : first.decode(dynamicOps, mapLike);
            }

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return second.keys(dynamicOps);
            }

            public String toString() {
                return String.valueOf(first) + " orCompressed " + String.valueOf(second);
            }
        };
    }

    public static float positiveAxis(float value) {
        return value < 0.0f ? 0.0f : value;
    }

    public static float negativeAxis(float value) {
        return value > 0.0f ? 0.0f : -value;
    }

    public static float mapShortToFloat(short value) {
        return Mth.clampedMap((float)value, (float)-32768.0f, (float)0.0f, (float)-1.0f, (float)0.0f) + Mth.clampedMap((float)value, (float)0.0f, (float)32767.0f, (float)0.0f, (float)1.0f);
    }

    public static ResourceLocation createResourceFont(ResourceLocation resource) {
        return resource;
    }

    private static enum URIOpener {
        WINDOWS(Util.OS.WINDOWS),
        OSX(Util.OS.OSX),
        LINUX(Util.OS.LINUX),
        SOLARIS(Util.OS.SOLARIS);

        private final Util.OS mcOS;

        private URIOpener(Util.OS mcOS) {
            this.mcOS = mcOS;
        }

        public String[] openArguments(URI uri) {
            String[] stringArray;
            switch (this.mcOS) {
                case WINDOWS: {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "rundll32";
                    stringArray2[1] = "url.dll,FileProtocolHandler";
                    stringArray = stringArray2;
                    stringArray2[2] = uri.toString();
                    break;
                }
                case OSX: {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "open";
                    stringArray = stringArray3;
                    stringArray3[1] = uri.toString();
                    break;
                }
                case LINUX: 
                case SOLARIS: {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = "xdg-open";
                    stringArray = stringArray4;
                    stringArray4[1] = uri.toString();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported OS: " + String.valueOf(this.mcOS));
                }
            }
            return stringArray;
        }

        public static URIOpener get() {
            return switch (Util.getPlatform()) {
                case Util.OS.WINDOWS -> WINDOWS;
                case Util.OS.OSX -> OSX;
                case Util.OS.LINUX -> LINUX;
                case Util.OS.SOLARIS -> SOLARIS;
                default -> throw new UnsupportedOperationException("Unsupported OS: " + String.valueOf(Util.getPlatform()));
            };
        }
    }
}

