/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;

public final class ColorUtils {
    public static int lerpARGB(float delta, int start, int end) {
        return ARGB.lerp((float)delta, (int)start, (int)end);
    }

    public static int argbRed(int argb) {
        return ARGB.red((int)argb);
    }

    public static int argbGreen(int argb) {
        return ARGB.green((int)argb);
    }

    public static int argbBlue(int argb) {
        return ARGB.blue((int)argb);
    }

    public static int argbAlpha(int argb) {
        return ARGB.alpha((int)argb);
    }

    public static float[] decomposeARGBFloat(int argb) {
        return new float[]{(float)ARGB.alpha((int)argb) / 255.0f, (float)ARGB.red((int)argb) / 255.0f, (float)ARGB.green((int)argb) / 255.0f, (float)ARGB.blue((int)argb) / 255.0f};
    }

    public static int grey(float brightness, float alpha) {
        int component = Mth.floor((float)(brightness * 255.0f));
        int color = Mth.floor((float)(alpha * 255.0f));
        color = color << 8 | component;
        color = color << 8 | component;
        color = color << 8 | component;
        return color;
    }
}

