/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;

public interface CGuiPose {
    public CGuiPose push();

    public CGuiPose pop();

    public CGuiPose translate(float var1, float var2);

    public CGuiPose scale(float var1, float var2);

    public CGuiPose nextLayer(float var1);

    public static CGuiPose of(GuiGraphics graphics) {
        return new Impl3D(graphics.pose());
    }

    public static CGuiPose ofPush(GuiGraphics graphics) {
        return CGuiPose.of(graphics).push();
    }

    public static class Impl3D
    implements CGuiPose {
        private final PoseStack stack;

        public Impl3D(PoseStack stack) {
            this.stack = stack;
        }

        @Override
        public CGuiPose push() {
            this.stack.pushPose();
            return this;
        }

        @Override
        public CGuiPose pop() {
            this.stack.popPose();
            return this;
        }

        @Override
        public CGuiPose translate(float x, float y) {
            this.stack.translate(x, y, 0.0f);
            return this;
        }

        @Override
        public CGuiPose scale(float x, float y) {
            this.stack.scale(x, y, 1.0f);
            return this;
        }

        @Override
        public CGuiPose nextLayer(float legacyZShift) {
            this.stack.translate(0.0f, 0.0f, legacyZShift);
            return this;
        }
    }
}

