/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import com.google.common.collect.Lists;
import dev.isxander.controlify.gui.guide.GuideDomain;
import dev.isxander.controlify.gui.guide.PrecomputedLines;
import dev.isxander.controlify.utils.render.Blit;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public final class GuideRenderer {
    private GuideRenderer() {
    }

    public static void render(GuiGraphics graphics, GuideDomain<?> domain, Minecraft minecraft, boolean bottomAligned, boolean textContrast) {
        int width = minecraft.getWindow().getGuiScaledWidth();
        int height = minecraft.getWindow().getGuiScaledHeight();
        Blit.batchDraw(graphics, () -> {
            GuideRenderer.renderLines(graphics, domain.leftGuides(), minecraft.font, width, height, bottomAligned, false, textContrast);
            GuideRenderer.renderLines(graphics, domain.rightGuides(), minecraft.font, width, height, bottomAligned, true, textContrast);
        });
    }

    private static void renderLines(GuiGraphics graphics, PrecomputedLines lines, Font font, int width, int height, boolean bottomAligned, boolean rightAligned, boolean textContrast) {
        int safeAreaX = 2;
        int safeAreaY = 5;
        int betweenLines = 2;
        int allLinesHeight = lines.height() + (lines.lines().size() - 1) * betweenLines;
        int x = rightAligned ? width - safeAreaX : safeAreaX;
        int y = bottomAligned ? height - allLinesHeight - safeAreaY : safeAreaY;
        List list = bottomAligned ? Lists.reverse(lines.lines()) : lines.lines();
        for (PrecomputedLines.PrecomputedLine line : list) {
            int lineX;
            int n = lineX = rightAligned ? x - line.width() : x;
            if (textContrast) {
                int n2 = lineX + line.backgroundLeft() - 1;
                int n3 = lineX + line.backgroundRight() + 1;
                Objects.requireNonNull(font);
                graphics.fill(n2, y - 1, n3, y + 9 + 1, Integer.MIN_VALUE);
            }
            graphics.drawString(font, line.text(), lineX, y, -1, !textContrast);
            y += line.height() + betweenLines;
        }
    }

    public static class Renderable
    implements net.minecraft.client.gui.components.Renderable {
        private final GuideDomain<?> domain;
        private final Minecraft minecraft;
        private boolean bottomAligned;
        private boolean textContrast;

        public Renderable(GuideDomain<?> domain, Minecraft minecraft, boolean bottomAligned, boolean textContrast) {
            this.domain = domain;
            this.minecraft = minecraft;
            this.bottomAligned = bottomAligned;
            this.textContrast = textContrast;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            GuideRenderer.render(guiGraphics, this.domain, this.minecraft, this.bottomAligned, this.textContrast);
        }

        public void setBottomAligned(boolean bottomAligned) {
            this.bottomAligned = bottomAligned;
        }

        public void setTextContrast(boolean textContrast) {
            this.textContrast = textContrast;
        }
    }
}

