/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.rumble.useitem;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.mixins.feature.rumble.useitem.LivingEntityMixin;
import dev.isxander.controlify.rumble.ContinuousRumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.rumble.effects.UseItemEffectHolder;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends LivingEntityMixin
implements UseItemEffectHolder {
    @Unique
    private ContinuousRumbleEffect useItemRumble;

    @Override
    protected void onStartUsingItem(InteractionHand hand, CallbackInfo ci, ItemStack stack) {
        switch (stack.getUseAnimation()) {
            case BOW: {
                this.startRumble(ContinuousRumbleEffect.builder().byTick(tick -> new RumbleState(tick % 7 <= 3 && tick > 20 ? 0.1f : 0.0f, BowItem.getPowerForTime((int)tick))).build());
                break;
            }
            case CROSSBOW: {
                int chargeDuration = CrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)((LocalPlayer)this));
                this.startRumble(ContinuousRumbleEffect.builder().byTick(tick -> new RumbleState(0.0f, (float)tick.intValue() / (float)chargeDuration)).timeout(chargeDuration).build());
                break;
            }
            case BLOCK: 
            case SPYGLASS: {
                this.startRumble(ContinuousRumbleEffect.builder().byTick(tick -> new RumbleState(0.0f, (float)(tick % 4) / 4.0f * 0.12f + 0.05f)).build());
                break;
            }
            case EAT: 
            case DRINK: {
                this.startRumble(ContinuousRumbleEffect.builder().constant(0.1f, 0.2f).build());
                break;
            }
            case TOOT_HORN: {
                this.startRumble(ContinuousRumbleEffect.builder().byTick(tick -> new RumbleState(Math.min(1.0f, (float)tick.intValue() / 10.0f), 0.25f)).build());
                break;
            }
            case SPEAR: {
                this.startRumble(ContinuousRumbleEffect.builder().constant(0.3f, 0.3f).build());
            }
        }
    }

    @Override
    protected void onUpdateUsingItem(ItemStack stack, CallbackInfo ci) {
    }

    @Override
    protected void onStopUsingItem(CallbackInfo ci) {
        if (this.useItemRumble != null) {
            this.useItemRumble.stop();
            this.useItemRumble = null;
        }
    }

    @Unique
    private void startRumble(ContinuousRumbleEffect effect) {
        ControlifyApi.get().playRumbleEffect(RumbleSource.INTERACTION, effect);
        this.useItemRumble = effect;
    }

    @Override
    @Nullable
    public ContinuousRumbleEffect controlify$getUseItemEffect() {
        return this.useItemRumble;
    }
}

