/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings.output;

import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.StateAccess;
import dev.isxander.controlify.bindings.output.DigitalOutput;

public class GuiPressOutput
implements DigitalOutput {
    private final StateAccess stateAccess;
    private PressState pressState = PressState.OFF;

    public GuiPressOutput(InputBinding binding) {
        this.stateAccess = binding.createStateAccess(2, state -> this.push());
    }

    @Override
    public boolean get() {
        return this.pressState == PressState.JUST_RELEASED;
    }

    public PressState getPressState() {
        return this.pressState;
    }

    private void push() {
        boolean held = this.stateAccess.digital(0);
        boolean prevHeld = this.stateAccess.digital(1);
        if (held) {
            if (!prevHeld) {
                this.pressState = PressState.COULD_PRESS_IN_FUTURE;
            }
        } else {
            this.pressState = prevHeld && this.pressState == PressState.COULD_PRESS_IN_FUTURE ? PressState.JUST_RELEASED : PressState.OFF;
        }
        if (this.stateAccess.isSuppressed()) {
            this.pressState = PressState.OFF;
        }
    }

    public void onNavigate() {
        this.pressState = PressState.OFF;
    }

    public static enum PressState {
        OFF,
        JUST_RELEASED,
        COULD_PRESS_IN_FUTURE;

    }
}

