/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.id;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.controlify.platform.client.resource.SimpleControlifyReloadListener;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.JsonTreeParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.quiltmc.parsers.json.JsonReader;

public class ControllerTypeManager
implements SimpleControlifyReloadListener<Preparations> {
    private Map<HIDIdentifier, ControllerType> typeMap = new HashMap<HIDIdentifier, ControllerType>();
    public static final class_2960 ID = CUtil.rl("controller_type");
    private static final Codec<ControllerTypeEntry> ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(HIDIdentifier.CODEC).comapFlatMap(list -> list.isEmpty() ? DataResult.error(() -> "At least one HID must be present") : DataResult.success((Object)list), list -> list).fieldOf("hids").forGetter(ControllerTypeEntry::hid), (App)ControllerType.CODEC.forGetter(ControllerTypeEntry::type)).apply((Applicative)instance, ControllerTypeEntry::new));

    public ControllerType getControllerType(HIDIdentifier hid) {
        return this.typeMap.getOrDefault(hid, ControllerType.DEFAULT);
    }

    public Map<HIDIdentifier, ControllerType> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public CompletableFuture<Preparations> load(class_3300 manager, Executor executor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> manager.method_14489(CUtil.rl("controllers/controller_identification.json5")), executor).thenCompose(resources -> {
            ArrayList<CompletableFuture<List>> futures = new ArrayList<CompletableFuture<List>>();
            for (class_3298 resource : resources) {
                futures.add(CompletableFuture.supplyAsync(() -> this.readIdentificationResource(resource), executor));
            }
            return class_156.method_33791(futures).thenApply(listOfEntries -> listOfEntries.stream().flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b)));
        })).thenApply(Preparations::new);
    }

    private List<Map.Entry<HIDIdentifier, ControllerType>> readIdentificationResource(class_3298 resource) {
        HashMap typeMap = new HashMap();
        try (BufferedReader resourceReader = resource.method_43039();){
            JsonReader reader = JsonReader.json5((Reader)resourceReader);
            JsonElement json = JsonTreeParser.parse(reader);
            ENTRY_CODEC.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(CUtil.LOGGER::error).ifPresent(entries -> {
                for (ControllerTypeEntry entry : entries) {
                    for (HIDIdentifier hid : entry.hid()) {
                        typeMap.put(hid, entry.type());
                    }
                }
            });
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to read controller identification database!", e);
        }
        return typeMap.entrySet().stream().toList();
    }

    @Override
    public CompletableFuture<Void> apply(Preparations data, class_3300 manager, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            this.typeMap = data.typeMap();
            this.triggerFullTypeReload();
        }, executor);
    }

    public void triggerFullTypeReload() {
        Optional<ControllerManager> controllerManagerOpt = Controlify.instance().getControllerManager();
        if (controllerManagerOpt.isPresent()) {
            ControllerManager controllerManager = controllerManagerOpt.get();
            for (ControllerEntity controller : controllerManager.getConnectedControllers()) {
                this.reloadTypeForController(controllerManager, controller);
            }
        }
    }

    public void reloadTypeForController(ControllerManager controllerManager, ControllerEntity controller) {
        ControllerType oldType;
        Optional<HIDDevice> hidOpt = controller.info().hid();
        if (hidOpt.isEmpty()) {
            return;
        }
        HIDDevice hid = hidOpt.get();
        ControllerType newType = this.getControllerType(hid.asIdentifier());
        if (!newType.equals(oldType = controller.info().type())) {
            controllerManager.reinitController(controller, new ControllerHIDService.ControllerHIDInfo(newType, controller.info().hid()));
        }
    }

    @Override
    public class_2960 getReloadId() {
        return ID;
    }

    public record Preparations(Map<HIDIdentifier, ControllerType> typeMap) {
    }

    private record ControllerTypeEntry(List<HIDIdentifier> hid, ControllerType type) {
    }
}

