/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import com.sun.jna.Platform;
import dev.isxander.controlify.driver.sdl.LoadedSDLNatives;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import dev.isxander.sdl3java.jna.SdlNativeLibraryLoader;
import java.nio.file.Path;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public final class SDLNativesLoader {
    private static final ControlifyLogger logger = CUtil.LOGGER.createSubLogger("SDLNativesLoader");
    private static boolean hasAttemptedLoad = false;
    @Nullable
    private static LoadedSDLNatives loadedSDLNatives;

    public static Optional<LoadedSDLNatives> get() {
        return Optional.ofNullable(loadedSDLNatives);
    }

    public static boolean hasAttemptedLoad() {
        return hasAttemptedLoad;
    }

    public static boolean isLoaded() {
        return loadedSDLNatives != null;
    }

    public static Optional<LoadedSDLNatives> getOrLoad() {
        SDLNativesLoader.tryLoad();
        return SDLNativesLoader.get();
    }

    public static boolean tryLoad() {
        if (hasAttemptedLoad) {
            return SDLNativesLoader.isLoaded();
        }
        hasAttemptedLoad = true;
        try {
            String path = "SDL3";
            if (CUtil.IS_POJAV_LAUNCHER) {
                logger.log("Detected PojavLauncher.");
                String nativesFolderName = System.getenv("POJAV_NATIVEDIR");
                Path libsLocation = Path.of(nativesFolderName, new String[0]).toAbsolutePath();
                path = libsLocation.resolve("libSDL3.so").toString();
            }
            logger.log("Attempting to load SDL3 from {}", path);
            SdlNativeLibraryLoader.loadLibSDL3FromFilePathNow((String)path);
            loadedSDLNatives = new LoadedSDLNatives();
            loadedSDLNatives.startSDL3();
            logger.log("Successfully loaded SDL3 natives");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Failed to find SDL. Need {}", e, Platform.RESOURCE_PREFIX);
        }
        catch (Throwable e) {
            logger.error("Failed to load SDL natives", e);
        }
        return false;
    }
}

