/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.platform.client.fabric;

import dev.isxander.controlify.platform.client.CreativeTabHelper;
import dev.isxander.controlify.platform.fabric.mixins.CreativeModeInventoryScreenAccessor;
import dev.isxander.controlify.utils.CUtil;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.impl.client.itemgroup.CreativeGuiExtensions;
import net.fabricmc.fabric.impl.client.itemgroup.FabricCreativeGuiComponents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.minecraft.class_1761;
import net.minecraft.class_481;
import net.minecraft.class_7706;

public class FAPIImplCreativeTabHelper
implements CreativeTabHelper {
    private final class_481 screen;
    private final CreativeGuiExtensions guiExt;
    private final int pageCount;

    public FAPIImplCreativeTabHelper(class_481 screen) {
        this.screen = screen;
        this.guiExt = (CreativeGuiExtensions)screen;
        int lastPage = 0;
        while (this.pageHasAnyTab(lastPage)) {
            ++lastPage;
        }
        this.pageCount = lastPage;
    }

    @Override
    public void setCurrentPage(int page) {
        int pageDiff = page - this.getCurrentPage();
        if (pageDiff == 0) {
            return;
        }
        boolean forwards = pageDiff > 0;
        for (int i = 0; i < Math.abs(pageDiff); ++i) {
            if (forwards) {
                this.guiExt.fabric_nextPage();
                continue;
            }
            this.guiExt.fabric_previousPage();
        }
    }

    @Override
    public int getCurrentPage() {
        return this.guiExt.fabric_currentPage();
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public List<class_1761> getTabsForPage(int page) {
        return class_7706.method_47335().stream().filter(tab -> page == this.getPageForTab((class_1761)tab)).sorted(Comparator.comparing(class_1761::method_47309).thenComparingInt(class_1761::method_7743)).sorted((a, b) -> {
            if (a.method_7752() && !b.method_7752()) {
                return 1;
            }
            if (!a.method_7752() && b.method_7752()) {
                return -1;
            }
            return 0;
        }).toList();
    }

    private int getPageForTab(class_1761 tab) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(tab)) {
            return this.getCurrentPage();
        }
        FabricItemGroup fabricItemGroup = (FabricItemGroup)tab;
        try {
            return fabricItemGroup.getPage();
        }
        catch (IllegalStateException e) {
            CUtil.LOGGER.error("Mod seems to have registered tab incorrectly: {}", tab.method_7737().getString());
            return -1;
        }
    }

    @Override
    public class_1761 getSelectedTab() {
        return CreativeModeInventoryScreenAccessor.getSelectedTab();
    }

    @Override
    public void setSelectedTab(class_1761 tab) {
        ((CreativeModeInventoryScreenAccessor)this.screen).invokeSelectTab(tab);
    }

    private boolean pageHasAnyTab(int page) {
        return class_7706.method_47335().stream().anyMatch(tab -> this.getPageForTab((class_1761)tab) == page);
    }
}

