/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.haptic.HapticEffects;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.sound.ControlifyClientSounds;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public class RadialMenuScreen
extends class_437
implements ScreenControllerEventListener,
ScreenProcessorProvider {
    public static final class_2960 EMPTY_ACTION = CUtil.rl("empty_action");
    private final ControllerEntity controller;
    @Nullable
    private final EditMode editMode;
    private final class_437 parent;
    private final class_2561 text;
    private final RadialItem[] items;
    private final RadialButton[] buttons;
    private float radialRadius;
    private final InputBinding openBind;
    private int selectedButton = -1;
    private int idleTicks;
    private final int idleTicksTimeout;
    private boolean isEditing;
    private ActionSelectList actionSelectList;
    private final Processor processor = new Processor(this);

    public RadialMenuScreen(ControllerEntity controller, InputBinding openBind, RadialItem[] items, class_2561 text, @Nullable EditMode editMode, class_437 parent) {
        super(text);
        this.text = text;
        this.controller = controller;
        this.items = items;
        this.buttons = new RadialButton[items.length];
        this.editMode = editMode;
        this.parent = parent;
        this.idleTicksTimeout = ((InputComponent.Config)controller.input().orElseThrow().confObj()).radialButtonFocusTimeoutTicks;
        this.openBind = openBind;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        float buttonRadius = (float)Math.sqrt(2048.0) + 8.0f;
        float circumference = buttonRadius * (float)this.items.length;
        this.radialRadius = Math.max(circumference / ((float)Math.PI * 2), 43.0f);
        Animation animation = Animation.of(5).easing(EasingFunction.EASE_OUT_QUAD);
        for (int i = 0; i < this.items.length; ++i) {
            float angle = (float)Math.PI * 2 * (float)i / (float)this.items.length - 1.5707964f;
            float x = (float)centerX + class_3532.method_15362((float)angle) * this.radialRadius;
            float y = (float)centerY + class_3532.method_15374((float)angle) * this.radialRadius;
            RadialButton button = this.buttons[i] = new RadialButton(this.items[i], centerX - 16, centerY - 16);
            animation.consumerF(button::setX, centerX - 16, x - 16.0f).consumerF(button::setY, centerY - 16, y - 16.0f);
            this.method_37063(button);
        }
        animation.play();
        if (this.editMode != null) {
            // empty if block
        }
    }

    @Override
    public void onControllerInput(ControllerEntity controller) {
        if (this.controller != controller) {
            return;
        }
        if (this.editMode == null && !this.openBind.digitalNow()) {
            if (this.selectedButton != -1 && this.buttons[this.selectedButton].invoke()) {
                this.playClickSound();
            }
            this.method_25419();
        }
        if (this.editMode != null && ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
            this.playClickSound();
            this.method_25419();
        }
        if (!this.isEditing) {
            float x = ControlifyBindings.RADIAL_AXIS_RIGHT.on(controller).analogueNow() - ControlifyBindings.RADIAL_AXIS_LEFT.on(controller).analogueNow();
            float y = ControlifyBindings.RADIAL_AXIS_DOWN.on(controller).analogueNow() - ControlifyBindings.RADIAL_AXIS_UP.on(controller).analogueNow();
            float threshold = controller.input().orElseThrow().config().config().buttonActivationThreshold;
            if (Math.abs(x) >= threshold || Math.abs(y) >= threshold) {
                float each;
                float angle = class_3532.method_15393((float)(57.295776f * (float)class_3532.method_15349((double)y, (double)x) - 90.0f)) + 180.0f;
                int newSelected = class_3532.method_15375((float)((angle + (each = 360.0f / (float)this.buttons.length) / 2.0f) / each)) % this.buttons.length;
                if (newSelected != this.selectedButton) {
                    this.selectedButton = newSelected;
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ControlifyClientSounds.SCREEN_FOCUS_CHANGE.get(), (float)1.0f));
                    controller.hdHaptics().ifPresent(haptics -> haptics.playHaptic(HapticEffects.NAVIGATE));
                }
                for (int i = 0; i < this.buttons.length; ++i) {
                    boolean selected = i == this.selectedButton;
                    this.buttons[i].method_25365(selected);
                    if (!selected) continue;
                    this.method_25395(this.buttons[i]);
                }
                this.idleTicks = 0;
            } else if (this.editMode == null) {
                ++this.idleTicks;
                if (this.idleTicks >= this.idleTicksTimeout && this.selectedButton != -1) {
                    this.selectedButton = -1;
                    for (RadialButton button : this.buttons) {
                        button.method_25365(false);
                    }
                    controller.hdHaptics().ifPresent(haptics -> haptics.playHaptic(HapticEffects.NAVIGATE));
                }
            }
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        if (this.editMode == null) {
            graphics.method_27534(this.field_22793, this.text, this.field_22789 / 2, this.field_22790 - 39, -1);
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.editMode != null) {
            super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void playClickSound() {
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    private void finishEditing() {
        this.isEditing = false;
        this.method_37066((class_364)this.actionSelectList);
        this.method_25395(null);
        this.actionSelectList = null;
    }

    public void method_25419() {
        Controlify.instance().config().saveIfDirty();
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return this.editMode != null;
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.processor;
    }

    public static class Processor
    extends ScreenProcessor<RadialMenuScreen> {
        public Processor(RadialMenuScreen screen) {
            super(screen);
        }

        @Override
        public VirtualMouseBehaviour virtualMouseBehaviour() {
            return VirtualMouseBehaviour.DISABLED;
        }
    }

    public static interface RadialItem {
        public class_2561 name();

        public RadialIcon icon();

        public boolean playAction();
    }

    public class RadialButton
    implements class_4068,
    class_364,
    class_6379,
    ComponentProcessor {
        public static final class_2960 TEXTURE = CUtil.rl("textures/gui/radial-buttons.png");
        private int x;
        private int y;
        private float translateX;
        private float translateY;
        private boolean focused;
        private RadialItem item;
        private class_5489 name;

        private RadialButton(RadialItem item, float x, float y) {
            this.setX(x);
            this.setY(y);
            this.setAction(item);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            CGuiPose pose = CGuiPose.ofPush(graphics);
            pose.translate((float)this.x + this.translateX, (float)this.y + this.translateY);
            pose.push();
            pose.scale(2.0f, 2.0f);
            Blit.tex(graphics, TEXTURE, 0, 0, this.focused ? 16 : 0, 0, 16, 16, 32, 16);
            pose.pop();
            if (RadialMenuScreen.this.editMode == null || !this.focused) {
                pose.push();
                pose.translate(4.0f, 4.0f);
                pose.scale(1.5f, 1.5f);
                this.item.icon().draw(graphics, 0, 0, delta);
                pose.pop();
            } else {
                class_2561 bind = ControlifyBindings.GUI_PRESS.on(RadialMenuScreen.this.controller).inputGlyph();
                class_327 class_3272 = RadialMenuScreen.this.field_22793;
                int n = 16 - RadialMenuScreen.this.field_22793.method_27525((class_5348)bind) / 2;
                Objects.requireNonNull(RadialMenuScreen.this.field_22793);
                graphics.method_27535(class_3272, bind, n, 16 - 9 / 2, -1);
            }
            pose.pop();
            if (this.focused) {
                int n = RadialMenuScreen.this.field_22789 / 2;
                int n2 = RadialMenuScreen.this.field_22790 / 2;
                Objects.requireNonNull(RadialMenuScreen.this.field_22793);
                int n3 = n2 - 9 / 2;
                int n4 = this.name.method_30887() - 1;
                Objects.requireNonNull(RadialMenuScreen.this.field_22793);
                this.name.method_30888(graphics, n, n3 - n4 * 9 / 2);
            }
        }

        public boolean invoke() {
            return this.item.playAction();
        }

        public void setAction(RadialItem item) {
            this.item = item;
            this.name = class_5489.method_30890((class_327)RadialMenuScreen.this.field_22793, (class_2561)item.name(), (int)((int)(RadialMenuScreen.this.radialRadius * 2.0f - 32.0f)));
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setX(float x) {
            this.x = (int)x;
            this.translateX = x - (float)this.x;
        }

        public void setY(float y) {
            this.y = (int)y;
            this.translateY = y - (float)this.y;
        }

        public boolean method_25370() {
            return this.focused;
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
            if (RadialMenuScreen.this.editMode != null && controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_PRESS.on(controller).justPressed()) {
                RadialButton button = RadialMenuScreen.this.buttons[RadialMenuScreen.this.selectedButton];
                int x = button.x < RadialMenuScreen.this.field_22789 / 2 ? button.x - 110 : button.x + 42;
                RadialMenuScreen.this.actionSelectList = new ActionSelectList(RadialMenuScreen.this.selectedButton, x, button.y, 100, 80);
                RadialMenuScreen.this.method_37063((class_364)RadialMenuScreen.this.actionSelectList);
                RadialMenuScreen.this.method_25395((class_364)RadialMenuScreen.this.actionSelectList);
                RadialMenuScreen.this.isEditing = true;
                return true;
            }
            return false;
        }

        public class_6379.class_6380 method_37018() {
            return this.method_25370() ? class_6379.class_6380.field_33786 : class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 builder) {
            builder.method_37034(class_6381.field_33788, this.item.name());
        }

        public class_8030 method_48202() {
            return new class_8030(this.x, this.y, 32, 32);
        }
    }

    public static interface EditMode {
        public void setRadialItem(int var1, RadialItem var2);

        public List<RadialItem> getEditCandidates();
    }

    public class ActionSelectList
    implements class_4068,
    class_4069,
    class_6379,
    ComponentProcessor {
        private final int radialIndex;
        private int x;
        private int y;
        private int width;
        private int height;
        private final int itemHeight = 10;
        private int scrollOffset;
        private boolean focused;
        private ActionEntry focusedEntry;
        private final List<ActionEntry> children = new ArrayList<ActionEntry>();

        public ActionSelectList(int index, int x, int y, int width, int height) {
            this.radialIndex = index;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            for (RadialItem item : RadialMenuScreen.this.editMode.getEditCandidates()) {
                this.children.add(new ActionEntry(item));
            }
            RadialItem item = RadialMenuScreen.this.items[this.radialIndex];
            this.children.stream().filter(action -> action.item.equals(item)).findAny().ifPresent(this::method_25395);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, Integer.MIN_VALUE);
            graphics.method_44379(this.x, this.y, this.x + this.width, this.y + this.height);
            int y = this.y - this.scrollOffset;
            for (ActionEntry child : this.children) {
                child.render(graphics, this.x, y, this.width, 10, mouseX, mouseY, delta);
                y += 10;
            }
            graphics.method_44380();
            graphics.method_49601(this.x - 1, this.y - 1, this.width + 2, this.height + 2, -2130706433);
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
            if (controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
                RadialMenuScreen.this.finishEditing();
                return true;
            }
            return false;
        }

        public List<ActionEntry> method_25396() {
            return this.children;
        }

        public boolean method_25397() {
            return false;
        }

        public void method_25398(boolean dragging) {
        }

        @Nullable
        public ActionEntry getFocused() {
            return this.focusedEntry;
        }

        public void method_25395(@Nullable class_364 child) {
            int index;
            ActionEntry focus;
            this.focusedEntry = focus = (ActionEntry)child;
            if (focus != null && (index = this.method_25396().indexOf(child)) != -1) {
                int focusY = index * 10 - this.scrollOffset;
                if (focusY < 0) {
                    this.scrollOffset = class_3532.method_15340((int)(index * 10), (int)0, (int)(this.method_25396().size() * 10 - this.height));
                } else if (focusY + 10 > this.height) {
                    this.scrollOffset = class_3532.method_15340((int)(index * 10 + 10 - this.height), (int)0, (int)(this.method_25396().size() * 10 - this.height));
                }
            }
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }

        public boolean method_25370() {
            return this.focused;
        }

        public class_6379.class_6380 method_37018() {
            return this.focused ? class_6379.class_6380.field_33786 : class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 builder) {
            if (this.getFocused() != null) {
                builder.method_37034(class_6381.field_33788, this.getFocused().item.name());
            }
        }

        public class ActionEntry
        implements class_364,
        ComponentProcessor {
            private int x;
            private int y;
            private boolean focused;
            private final RadialItem item;

            public ActionEntry(RadialItem item) {
                this.item = item;
            }

            public void render(class_332 graphics, int x, int y, int width, int itemHeight, int mouseX, int mouseY, float delta) {
                this.x = x;
                this.y = y;
                if (this.focused) {
                    graphics.method_25294(x, y, x + width, y + itemHeight, -16777216);
                }
                graphics.method_27535(RadialMenuScreen.this.field_22793, this.item.name(), x + 2, y + 1, this.focused ? -1 : -5855578);
            }

            public void method_25365(boolean focused) {
                this.focused = focused;
            }

            public boolean method_25370() {
                return this.focused;
            }

            @Nullable
            public class_8016 method_48205(class_8023 event) {
                return !this.focused ? class_8016.method_48193((class_364)this) : null;
            }

            public class_8030 method_48202() {
                return new class_8030(this.x, this.y, ActionSelectList.this.width, 10);
            }

            @Override
            public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
                if (controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_PRESS.on(controller).justPressed()) {
                    RadialMenuScreen.this.editMode.setRadialItem(ActionSelectList.this.radialIndex, this.item);
                    Controlify.instance().config().setDirty();
                    RadialMenuScreen.this.buttons[ActionSelectList.this.radialIndex].setAction(this.item);
                    RadialMenuScreen.this.playClickSound();
                    RadialMenuScreen.this.finishEditing();
                    return true;
                }
                return false;
            }
        }
    }
}

