/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.keyboard;

public interface InputTarget {
    public static final InputTarget EMPTY = new InputTarget(){};

    default public boolean supportsCharInput() {
        return false;
    }

    default public boolean acceptChar(char ch, int modifiers) {
        return false;
    }

    default public boolean supportsKeyCodeInput() {
        return false;
    }

    default public boolean acceptKeyCode(int keycode, int scancode, int modifiers) {
        return false;
    }

    default public boolean supportsCopying() {
        return false;
    }

    default public boolean copy() {
        return false;
    }

    default public boolean supportsCursorMovement() {
        return false;
    }

    default public boolean moveCursor(int amount) {
        return false;
    }

    public static class Delegated
    implements InputTarget {
        private final InputTarget target;

        public Delegated(InputTarget target) {
            this.target = target;
        }

        @Override
        public boolean supportsCharInput() {
            return this.target.supportsCharInput();
        }

        @Override
        public boolean acceptChar(char ch, int modifiers) {
            return this.target.acceptChar(ch, modifiers);
        }

        @Override
        public boolean supportsKeyCodeInput() {
            return this.target.supportsKeyCodeInput();
        }

        @Override
        public boolean acceptKeyCode(int keycode, int scancode, int modifiers) {
            return this.target.acceptKeyCode(keycode, scancode, modifiers);
        }

        @Override
        public boolean supportsCopying() {
            return this.target.supportsCopying();
        }

        @Override
        public boolean copy() {
            return this.target.copy();
        }

        @Override
        public boolean supportsCursorMovement() {
            return this.target.supportsCursorMovement();
        }

        @Override
        public boolean moveCursor(int amount) {
            return this.target.moveCursor(amount);
        }
    }
}

