/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.gyro.GyroComponent;
import dev.isxander.controlify.controller.gyro.GyroState;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.impl.ControllerStateImpl;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.touchpad.TouchpadComponent;
import dev.isxander.controlify.controller.touchpad.Touchpads;
import dev.isxander.controlify.driver.sdl.SDLCommonDriver;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.gamepad.SDL_Gamepad;
import dev.isxander.sdl3java.api.gamepad.SdlGamepad;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickGUID;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.properties.SDL_PropertiesID;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class SDL3GamepadDriver
extends SDLCommonDriver<SDL_Gamepad> {
    private InputComponent inputComponent;
    private GyroComponent gyroComponent;
    private TouchpadComponent touchpadComponent;
    private final boolean isGryoSupported;
    private final int numTouchpads;

    public SDL3GamepadDriver(SDL_Gamepad ptrController, SDL_JoystickID jid, ControllerType type, ControlifyLogger logger) {
        super(ptrController, jid, type, logger);
        this.isGryoSupported = SdlGamepad.SDL_GamepadHasSensor((SDL_Gamepad)ptrController, (int)2);
        this.numTouchpads = SdlGamepad.SDL_GetNumGamepadTouchpads((SDL_Gamepad)ptrController);
        if (this.isGryoSupported) {
            SdlGamepad.SDL_SetGamepadSensorEnabled((SDL_Gamepad)ptrController, (int)2, (boolean)true);
        }
    }

    @Override
    public void addComponents(ControllerEntity controller) {
        super.addComponents(controller);
        this.inputComponent = new InputComponent(controller, 21, 10, 0, true, GamepadInputs.DEADZONE_GROUPS, controller.info().type().mappingId());
        controller.setComponent(this.inputComponent);
        if (this.isGryoSupported) {
            this.gyroComponent = new GyroComponent();
            controller.setComponent(this.gyroComponent);
        }
        if (this.numTouchpads > 0) {
            this.touchpadComponent = new TouchpadComponent(new Touchpads((Touchpads.Touchpad[])IntStream.range(0, this.numTouchpads).mapToObj(i -> new Touchpads.Touchpad(SdlGamepad.SDL_GetNumGamepadTouchpadFingers((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)i))).toArray(Touchpads.Touchpad[]::new)));
            controller.setComponent(this.touchpadComponent);
        }
    }

    @Override
    public void update(ControllerEntity controller, boolean outOfFocus) {
        super.update(controller, outOfFocus);
        this.updateInput();
        this.updateGyro();
        this.updateTouchpad();
    }

    private void updateInput() {
        ControllerStateImpl state = new ControllerStateImpl();
        state.setAxis(GamepadInputs.LEFT_STICK_AXIS_RIGHT, CUtil.positiveAxis(CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)0))));
        state.setAxis(GamepadInputs.LEFT_STICK_AXIS_LEFT, CUtil.negativeAxis(CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)0))));
        state.setAxis(GamepadInputs.LEFT_STICK_AXIS_UP, CUtil.negativeAxis(CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)1))));
        state.setAxis(GamepadInputs.LEFT_STICK_AXIS_DOWN, CUtil.positiveAxis(CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)1))));
        state.setAxis(GamepadInputs.RIGHT_STICK_AXIS_RIGHT, CUtil.positiveAxis(CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)2))));
        state.setAxis(GamepadInputs.RIGHT_STICK_AXIS_LEFT, CUtil.negativeAxis(CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)2))));
        state.setAxis(GamepadInputs.RIGHT_STICK_AXIS_UP, CUtil.negativeAxis(CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)3))));
        state.setAxis(GamepadInputs.RIGHT_STICK_AXIS_DOWN, CUtil.positiveAxis(CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)3))));
        state.setAxis(GamepadInputs.LEFT_TRIGGER_AXIS, CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)4)));
        state.setAxis(GamepadInputs.RIGHT_TRIGGER_AXIS, CUtil.mapShortToFloat(SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)5)));
        state.setButton(GamepadInputs.SOUTH_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)0));
        state.setButton(GamepadInputs.EAST_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)1));
        state.setButton(GamepadInputs.WEST_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)2));
        state.setButton(GamepadInputs.NORTH_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)3));
        state.setButton(GamepadInputs.LEFT_SHOULDER_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)9));
        state.setButton(GamepadInputs.RIGHT_SHOULDER_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)10));
        state.setButton(GamepadInputs.BACK_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)4));
        state.setButton(GamepadInputs.START_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)6));
        state.setButton(GamepadInputs.GUIDE_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)5));
        state.setButton(GamepadInputs.DPAD_UP_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)11));
        state.setButton(GamepadInputs.DPAD_DOWN_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)12));
        state.setButton(GamepadInputs.DPAD_LEFT_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)13));
        state.setButton(GamepadInputs.DPAD_RIGHT_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)14));
        state.setButton(GamepadInputs.LEFT_STICK_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)7));
        state.setButton(GamepadInputs.RIGHT_STICK_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)8));
        state.setButton(GamepadInputs.MISC_1_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)15));
        state.setButton(GamepadInputs.MISC_2_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)21));
        state.setButton(GamepadInputs.MISC_3_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)22));
        state.setButton(GamepadInputs.MISC_4_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)23));
        state.setButton(GamepadInputs.MISC_5_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)24));
        state.setButton(GamepadInputs.MISC_6_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)25));
        state.setButton(GamepadInputs.LEFT_PADDLE_1_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)17));
        state.setButton(GamepadInputs.LEFT_PADDLE_2_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)19));
        state.setButton(GamepadInputs.RIGHT_PADDLE_1_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)16));
        state.setButton(GamepadInputs.RIGHT_PADDLE_2_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)18));
        state.setButton(GamepadInputs.TOUCHPAD_1_BUTTON, SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)20));
        this.inputComponent.pushState(state);
    }

    private void updateGyro() {
        if (!this.isGryoSupported) {
            return;
        }
        float[] gyro = new float[3];
        try (Memory memory = new Memory((long)(gyro.length * 4));){
            if (SdlGamepad.SDL_GetGamepadSensorData((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)2, (Pointer)memory, (int)3)) {
                memory.read(0L, gyro, 0, gyro.length);
                this.gyroComponent.setState(new GyroState(gyro[0], gyro[1], gyro[2]));
            } else {
                CUtil.LOGGER.error("Could not get gyro data: {}", SdlError.SDL_GetError());
            }
        }
    }

    private void updateTouchpad() {
        if (this.numTouchpads < 1) {
            return;
        }
        for (int touchpadIdx = 0; touchpadIdx < this.numTouchpads; ++touchpadIdx) {
            Touchpads.Touchpad touchpad = this.touchpadComponent.touchpads()[touchpadIdx];
            ArrayList<Touchpads.Finger> fingers = new ArrayList<Touchpads.Finger>();
            for (int fingerIdx = 0; fingerIdx < touchpad.maxFingers(); ++fingerIdx) {
                ByteByReference fingerState = new ByteByReference();
                FloatByReference x = new FloatByReference();
                FloatByReference y = new FloatByReference();
                FloatByReference pressure = new FloatByReference();
                if (!SdlGamepad.SDL_GetGamepadTouchpadFinger((SDL_Gamepad)((SDL_Gamepad)this.ptrController), (int)touchpadIdx, (int)fingerIdx, (ByteByReference)fingerState, (FloatByReference)x, (FloatByReference)y, (FloatByReference)pressure)) {
                    CUtil.LOGGER.error("Failed to fetch touchpad finger: {}", SdlError.SDL_GetError());
                    continue;
                }
                if (fingerState.getValue() != 1) continue;
                fingers.add(new Touchpads.Finger(fingerIdx, (Vector2fc)new Vector2f(x.getValue(), y.getValue()), pressure.getValue()));
            }
            touchpad.pushFingers(fingers);
        }
    }

    @Override
    protected SDL_PropertiesID SDL_GetControllerProperties(SDL_Gamepad ptrController) {
        return SdlGamepad.SDL_GetGamepadProperties((SDL_Gamepad)ptrController);
    }

    @Override
    protected String SDL_GetControllerName(SDL_Gamepad ptrController) {
        return SdlGamepad.SDL_GetGamepadName((SDL_Gamepad)ptrController);
    }

    @Override
    protected SDL_JoystickGUID SDL_GetControllerGUIDForID(SDL_JoystickID jid) {
        return SdlGamepad.SDL_GetGamepadGUIDForID((SDL_JoystickID)jid);
    }

    @Override
    protected String SDL_GetControllerSerial(SDL_Gamepad ptrController) {
        return SdlGamepad.SDL_GetGamepadSerial((SDL_Gamepad)ptrController);
    }

    @Override
    protected short SDL_GetControllerVendor(SDL_Gamepad ptrController) {
        return (short)SdlGamepad.SDL_GetGamepadVendor((SDL_Gamepad)ptrController);
    }

    @Override
    protected short SDL_GetControllerProduct(SDL_Gamepad ptrController) {
        return (short)SdlGamepad.SDL_GetGamepadProduct((SDL_Gamepad)ptrController);
    }

    @Override
    protected int SDL_GetControllerConnectionState(SDL_Gamepad ptrController) {
        return SdlGamepad.SDL_GetGamepadConnectionState((SDL_Gamepad)ptrController);
    }

    @Override
    protected boolean SDL_CloseController(SDL_Gamepad ptrController) {
        return SdlGamepad.SDL_CloseGamepad((SDL_Gamepad)ptrController);
    }

    @Override
    protected boolean SDL_RumbleController(SDL_Gamepad ptrController, float strong, float weak, int durationMs) {
        return SdlGamepad.SDL_RumbleGamepad((SDL_Gamepad)ptrController, (char)((char)(strong * 65535.0f)), (char)((char)(weak * 65535.0f)), (long)durationMs);
    }

    @Override
    protected boolean SDL_RumbleControllerTriggers(SDL_Gamepad ptrController, float left, float right, int durationMs) {
        return SdlGamepad.SDL_RumbleGamepadTriggers((SDL_Gamepad)ptrController, (char)((char)(left * 65535.0f)), (char)((char)(right * 65535.0f)), (long)durationMs);
    }

    @Override
    protected int SDL_GetControllerPowerInfo(SDL_Gamepad ptrController, IntByReference percent) {
        return SdlGamepad.SDL_GetGamepadPowerInfo((SDL_Gamepad)ptrController, (IntByReference)percent);
    }

    @Override
    protected boolean SDL_SendControllerEffect(SDL_Gamepad ptrController, Pointer effect, int size) {
        return SdlGamepad.SDL_SendGamepadEffect((SDL_Gamepad)ptrController, (Pointer)effect, (int)size);
    }

    @Override
    protected boolean SDL_SetControllerLED(SDL_Gamepad ptrController, byte red, byte green, byte blue) {
        return SdlGamepad.SDL_SetGamepadLED((SDL_Gamepad)ptrController, (byte)red, (byte)green, (byte)blue);
    }
}

