/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.rumble;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import dev.isxander.controlify.utils.CUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public record RumbleSource(class_2960 id) {
    public static final Codec<RumbleSource> CODEC = class_2960.field_25139.xmap(RumbleSource::get, RumbleSource::id);
    private static final Map<class_2960, RumbleSource> SOURCES = new Object2ObjectLinkedOpenHashMap();
    public static final RumbleSource MASTER = RumbleSource.register("master");
    public static final RumbleSource PLAYER = RumbleSource.register("player");
    public static final RumbleSource WORLD = RumbleSource.register("world");
    public static final RumbleSource INTERACTION = RumbleSource.register("interaction");
    public static final RumbleSource GUI = RumbleSource.register("gui");

    public static RumbleSource get(class_2960 id) {
        RumbleSource source = SOURCES.get(id);
        if (source == null) {
            CUtil.LOGGER.warn("Unknown rumble source: {}. Using master.", id);
            return MASTER;
        }
        return source;
    }

    public static Collection<RumbleSource> values() {
        return SOURCES.values();
    }

    public static JsonObject getDefaultJson() {
        JsonObject object = new JsonObject();
        for (RumbleSource source : SOURCES.values()) {
            object.addProperty(source.id().toString(), (Number)Float.valueOf(1.0f));
        }
        return object;
    }

    public static Map<class_2960, Float> getDefaultMap() {
        HashMap<class_2960, Float> map = new HashMap<class_2960, Float>();
        for (RumbleSource source : SOURCES.values()) {
            map.put(source.id(), Float.valueOf(1.0f));
        }
        return map;
    }

    public static RumbleSource register(class_2960 id) {
        RumbleSource source = new RumbleSource(id);
        SOURCES.put(id, source);
        return source;
    }

    public static RumbleSource register(String identifier, String path) {
        return RumbleSource.register(class_2960.method_60655((String)identifier, (String)path));
    }

    private static RumbleSource register(String path) {
        return RumbleSource.register("controlify", path);
    }
}

