/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.wireless;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.battery.BatteryLevelComponent;
import dev.isxander.controlify.controller.battery.PowerState;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.utils.ToastUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2561;

public class LowBatteryNotifier {
    private static final Set<String> notifiedControllers = new HashSet<String>();
    private static int interval;

    public static void tick() {
        if (interval > 0) {
            --interval;
            return;
        }
        interval = 1200;
        if (!Controlify.instance().config().globalSettings().notifyLowBattery) {
            return;
        }
        ControllerManager controllerManager = Controlify.instance().getControllerManager().orElse(null);
        if (controllerManager == null) {
            return;
        }
        for (ControllerEntity controller : controllerManager.getConnectedControllers()) {
            PowerState.Depleting depleting;
            PowerState batteryLevel = controller.batteryLevel().map(BatteryLevelComponent::getBatteryLevel).orElse(new PowerState.Unknown());
            String uid = controller.uid();
            if (batteryLevel instanceof PowerState.Depleting && (depleting = (PowerState.Depleting)batteryLevel).percent() <= 10) {
                if (notifiedControllers.contains(uid)) continue;
                ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.low_battery.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.low_battery.message", (Object[])new Object[]{controller.name(), depleting.percent() + "%"}), true);
                notifiedControllers.add(uid);
                continue;
            }
            notifiedControllers.remove(uid);
        }
    }
}

