/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.api.guide;

import dev.isxander.controlify.api.guide.CommonFacts;
import dev.isxander.controlify.api.guide.Fact;
import dev.isxander.controlify.api.guide.FactProvider;
import dev.isxander.controlify.api.guide.InGameCtx;
import dev.isxander.controlify.gui.guide.GuideDomains;
import dev.isxander.controlify.mixins.feature.guide.ingame.PlayerAccessor;
import dev.isxander.controlify.utils.CUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;

public final class InGameFacts {
    public static final Fact<InGameCtx> ON_GROUND = InGameFacts.register(CUtil.rl("on_ground"), ctx -> ctx.player().onGround());
    public static final Fact<InGameCtx> IN_VEHICLE = InGameFacts.register(CUtil.rl("in_vehicle"), ctx -> ctx.player().getVehicle() != null);
    public static final Fact<InGameCtx> RIDING_SADDLED_HORSE = InGameFacts.register(CUtil.rl("riding_saddled_horse"), ctx -> {
        AbstractHorse horse;
        Entity patt0$temp = ctx.player().getVehicle();
        return patt0$temp instanceof AbstractHorse && (horse = (AbstractHorse)patt0$temp).isSaddled();
    });
    public static final Fact<InGameCtx> RIDING_HAPPY_GHAST = InGameFacts.register(CUtil.rl("riding_happy_ghast"));
    public static final Fact<InGameCtx> FLYING = InGameFacts.register(CUtil.rl("flying"), ctx -> ctx.player().getAbilities().flying);
    public static final Fact<InGameCtx> ELYTRA_FLYING = InGameFacts.register(CUtil.rl("elytra_flying"), ctx -> ctx.player().isFallFlying());
    public static final Fact<InGameCtx> CAN_ELYTRA_FLY = InGameFacts.register(CUtil.rl("can_elytra_fly"), ctx -> ((PlayerAccessor)ctx.player()).callCanGlide() && !ctx.player().onClimbable() && !ctx.player().onGround() && !ctx.player().isInLiquid() && !ctx.player().isFallFlying());
    public static final Fact<InGameCtx> IN_LIQUID = InGameFacts.register(CUtil.rl("in_liquid"), ctx -> ctx.player().isInLiquid());
    public static final Fact<InGameCtx> IN_WATER = InGameFacts.register(CUtil.rl("in_water"), ctx -> ctx.player().isInWater());
    public static final Fact<InGameCtx> UNDER_WATER = InGameFacts.register(CUtil.rl("under_water"), ctx -> ctx.player().isUnderWater());
    public static final Fact<InGameCtx> IN_LAVA = InGameFacts.register(CUtil.rl("in_lava"), ctx -> ctx.player().isInLava());
    public static final Fact<InGameCtx> SNEAKING = InGameFacts.register(CUtil.rl("sneaking"), ctx -> ctx.player().isShiftKeyDown());
    public static final Fact<InGameCtx> IS_TOGGLE_SNEAK = InGameFacts.register(CUtil.rl("is_toggle_sneak"), ctx -> ctx.controller().genericConfig().config().toggleSneak);
    public static final Fact<InGameCtx> IS_TOGGLE_SPRINT = InGameFacts.register(CUtil.rl("is_toggle_sprint"), ctx -> ctx.controller().genericConfig().config().toggleSprint);
    public static final Fact<InGameCtx> SPRINTING = InGameFacts.register(CUtil.rl("sprinting"), ctx -> ctx.player().input.keyPresses.sprint());
    public static final Fact<InGameCtx> INPUT_MOVING = InGameFacts.register(CUtil.rl("input_moving"), ctx -> !ctx.player().input.getMoveVector().equals(Vec2.ZERO));
    public static final Fact<InGameCtx> IS_SPECTATOR = InGameFacts.register(CUtil.rl("is_spectator"), ctx -> ctx.player().isSpectator());
    public static final Fact<InGameCtx> IS_CREATIVE = InGameFacts.register(CUtil.rl("is_creative"), ctx -> ctx.player().isCreative());
    public static final Fact<InGameCtx> HAS_HEARTS = InGameFacts.register(CUtil.rl("has_hearts"), ctx -> !ctx.player().getAbilities().invulnerable);
    public static final Fact<InGameCtx> IS_ADVENTURE = InGameFacts.register(CUtil.rl("is_adventure"), ctx -> InGameFacts.getGameMode(ctx) == GameType.ADVENTURE);
    public static final Fact<InGameCtx> IS_SURVIVAL = InGameFacts.register(CUtil.rl("is_survival"), ctx -> InGameFacts.getGameMode(ctx) == GameType.SURVIVAL);
    public static final Fact<InGameCtx> LOOKING_AT_ENTITY = InGameFacts.register(CUtil.rl("looking_at_entity"), ctx -> ctx.hitResult().getType() == HitResult.Type.ENTITY);
    public static final Fact<InGameCtx> LOOKING_AT_BLOCK = InGameFacts.register(CUtil.rl("looking_at_block"), ctx -> ctx.hitResult().getType() == HitResult.Type.BLOCK);
    public static final Fact<InGameCtx> LOOKING_AT_AIR = InGameFacts.register(CUtil.rl("looking_at_air"), ctx -> ctx.hitResult().getType() == HitResult.Type.MISS);
    public static final Fact<InGameCtx> HAS_ITEM_IN_EITHER_HAND = InGameFacts.register(CUtil.rl("has_item_in_either_hand"), ctx -> ctx.player().hasItemInSlot(EquipmentSlot.MAINHAND) || ctx.player().hasItemInSlot(EquipmentSlot.OFFHAND));
    public static final Fact<InGameCtx> HAS_ITEM_IN_MAINHAND = InGameFacts.register(CUtil.rl("has_item_in_mainhand"), ctx -> ctx.player().hasItemInSlot(EquipmentSlot.MAINHAND));
    public static final Fact<InGameCtx> HAS_ITEM_IN_OFFHAND = InGameFacts.register(CUtil.rl("has_item_in_offhand"), ctx -> ctx.player().hasItemInSlot(EquipmentSlot.OFFHAND));
    public static final Fact<InGameCtx> HAS_MULTIPLE_ITEMS_IN_HAND = InGameFacts.register(CUtil.rl("has_multiple_items_in_hand"), ctx -> {
        ItemStack holdingItem = ctx.player().getInventory().getSelected();
        return !holdingItem.isEmpty() && holdingItem.getCount() > 1;
    });

    private InGameFacts() {
    }

    private static GameType getGameMode(InGameCtx ctx) {
        return ctx.client().gameMode.getPlayerMode();
    }

    private static Fact<InGameCtx> register(ResourceLocation id, FactProvider<InGameCtx> provider) {
        Fact<InGameCtx> fact = Fact.of(id, provider);
        GuideDomains.IN_GAME.registerFact(fact);
        return fact;
    }

    private static Fact<InGameCtx> register(ResourceLocation id) {
        return InGameFacts.register(id, FactProvider.staticProvider(false));
    }

    public static void registerAll() {
        CommonFacts.registerAll();
    }
}

