/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ClientUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class SubmitUnknownControllerScreen
extends Screen
implements DontInteruptScreen {
    public static final String SUBMISSION_URL = "https://api-controlify.isxander.dev/api/v1/submit";
    public static final Pattern NAME_PATTERN = Pattern.compile("^[\\w\\- ]{3,64}$");
    private final ControllerEntity controller;
    private Checkbox operationalCheckbox;
    private final Screen lastScreen;
    private boolean invalidName;
    private Button submitButton;
    private EditBox nameField;

    public SubmitUnknownControllerScreen(ControllerEntity controller, Screen lastScreen) {
        super((Component)Component.translatable((String)"controlify.controller_submission.title").withStyle(ChatFormatting.BOLD));
        if (!SubmitUnknownControllerScreen.canSubmit(controller)) {
            throw new IllegalArgumentException("Controller ineligible for submission!");
        }
        this.controller = controller;
        this.lastScreen = lastScreen;
    }

    protected void init() {
        MultiLineTextWidget content = (MultiLineTextWidget)this.addRenderableWidget((GuiEventListener)new MultiLineTextWidget((Component)Component.translatable((String)"controlify.controller_submission.message"), this.font));
        content.setMaxWidth(this.width - 100);
        content.setX(this.width / 2 - content.getWidth() / 2);
        int titleBottomPadding = 11;
        int checkboxPadding = 6;
        int checkboxHeight = 20;
        int buttonHeight = 20;
        int nameFieldPaddingTop = 5;
        int nameFieldHeight = 20;
        int errorPadding = 4;
        Objects.requireNonNull(this.font);
        int n = 9 + titleBottomPadding + content.getHeight() + checkboxPadding + checkboxHeight + checkboxPadding + buttonHeight + nameFieldPaddingTop + nameFieldHeight + errorPadding;
        Objects.requireNonNull(this.font);
        int allHeight = n + 9;
        int y = this.height / 2 - allHeight / 2;
        this.addRenderableWidget((GuiEventListener)ClientUtils.createStringWidget(this.getTitle(), this.font, 25, y));
        Objects.requireNonNull(this.font);
        content.setY(y += 9 + titleBottomPadding);
        MutableComponent operationalText = Component.translatable((String)"controlify.controller_submission.operational_checkbox").withStyle(ChatFormatting.BOLD);
        this.operationalCheckbox = Checkbox.builder((Component)operationalText, (Font)this.font).pos(this.width / 2 - this.font.width((FormattedText)operationalText) / 2 - 8, y += content.getHeight() + checkboxPadding).selected(true).build();
        this.addRenderableWidget((GuiEventListener)this.operationalCheckbox);
        this.submitButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"controlify.controller_submission.submit"), this::onSubmitButton).pos(this.width / 2 - 155, y += checkboxHeight + checkboxPadding).width(150).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"controlify.controller_submission.skip"), btn -> this.onClose()).pos(this.width / 2 + 5, y).width(150).build());
        this.nameField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 155, y += buttonHeight + nameFieldPaddingTop, 310, 20, (Component)Component.translatable((String)"controlify.controller_submission.name_narration")));
        this.nameField.setHint((Component)Component.translatable((String)"controlify.controller_submission.name_hint"));
        this.nameField.setValue(this.controller.name());
        this.nameField.setFilter(s -> {
            this.invalidName = !this.checkValidName((String)s);
            this.submitButton.active = !this.invalidName;
            return true;
        });
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        if (this.invalidName) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"controlify.controller_submission.invalid_name").withStyle(ChatFormatting.RED), this.width / 2, this.nameField.getRectangle().bottom() + 4, -1);
        }
    }

    protected void onSubmitButton(Button button) {
        if (this.submit()) {
            this.dontShowAgain();
            this.onClose();
        } else {
            this.dontShowAgain();
            this.onClose();
        }
    }

    protected boolean submit() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(SUBMISSION_URL)).POST(HttpRequest.BodyPublishers.ofString(this.generateRequestBody())).header("Content-Type", "application/json").build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 != 2) {
                CUtil.LOGGER.error("Received non-2xx status code from '{}', got {} with body '{}'", SUBMISSION_URL, response.statusCode(), response.body());
                return false;
            }
            CUtil.LOGGER.log("Successfully sent controller information to '{}'", SUBMISSION_URL);
            return true;
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to submit controller to '%s'".formatted(SUBMISSION_URL), e);
            return false;
        }
    }

    private String generateRequestBody() {
        HIDDevice hid = this.controller.info().hid().orElseThrow();
        JsonObject object = new JsonObject();
        object.addProperty("vendorID", (Number)hid.vendorId());
        object.addProperty("productID", (Number)hid.productId());
        object.addProperty("GUID", this.controller.guid());
        object.addProperty("reportedName", this.nameField.getValue());
        object.addProperty("controlifyVersion", PlatformMainUtil.getControlifyVersion());
        object.addProperty("operational", Boolean.valueOf(this.operationalCheckbox.selected()));
        Gson gson = new Gson();
        return gson.toJson((JsonElement)object);
    }

    private boolean checkValidName(String name) {
        return NAME_PATTERN.matcher(name.trim()).matches();
    }

    private void dontShowAgain() {
        this.controller.genericConfig().config().dontShowControllerSubmission = true;
        Controlify.instance().config().setDirty();
    }

    public void onClose() {
        this.dontShowAgain();
        Controlify.instance().config().saveIfDirty();
        this.minecraft.setScreen(this.lastScreen);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public static boolean canSubmit(ControllerEntity controller) {
        return controller.info().type() == ControllerType.DEFAULT && !controller.genericConfig().config().dontShowControllerSubmission;
    }
}

