/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

import com.mojang.blaze3d.pipeline.RenderTarget;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.ingameinput.LookInputModifier;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.gyro.GyroButtonMode;
import dev.isxander.controlify.controller.gyro.GyroComponent;
import dev.isxander.controlify.controller.gyro.GyroState;
import dev.isxander.controlify.controller.gyro.GyroYawMode;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.driver.steamdeck.SteamDeckDriver;
import dev.isxander.controlify.gui.screen.RadialItems;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.ingame.ControllerPlayerMovement;
import dev.isxander.controlify.ingame.PickBlockAccessor;
import dev.isxander.controlify.mixins.feature.steamdeck.ScreenshotAccessor;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.DebugOverlayHelper;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import java.io.File;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class InGameInputHandler {
    private final ControllerEntity controller;
    private final Controlify controlify;
    private final Minecraft minecraft;
    private double lookInputX;
    private double lookInputY;
    private final GyroState gyroInput = new GyroState();
    private boolean gyroToggledOn;
    private boolean wasAiming;
    private Animation flickAnimation;
    private boolean shouldShowPlayerList;
    private final HoldRepeatHelper dropRepeatHelper;
    private boolean dropRepeating;
    private final HoldRepeatHelper hotbarNextRepeatHelper;
    private final HoldRepeatHelper hotbarPrevRepeatHelper;

    public InGameInputHandler(ControllerEntity controller) {
        this.controller = controller;
        this.minecraft = Minecraft.getInstance();
        this.controlify = Controlify.instance();
        this.dropRepeatHelper = new HoldRepeatHelper(20, 1);
        this.hotbarNextRepeatHelper = new HoldRepeatHelper(10, 4);
        this.hotbarPrevRepeatHelper = new HoldRepeatHelper(10, 4);
        this.gyroToggledOn = false;
    }

    public void inputTick() {
        boolean isController = ControllerPlayerMovement.shouldBeControllerInput();
        this.handlePlayerLookInput(isController);
        ControllerPlayerMovement.ensureCorrectInput(this.minecraft.player);
        if (isController) {
            this.handleKeybinds();
            this.preventFlyDrifting();
        }
    }

    protected void handleKeybinds() {
        if (this.minecraft.screen != null) {
            return;
        }
        if (ControlifyBindings.PAUSE.on(this.controller).justPressed()) {
            this.minecraft.pauseGame(false);
        }
        if (this.minecraft.player != null) {
            Inventory inventory = this.minecraft.player.getInventory();
            if (this.hotbarNextRepeatHelper.shouldAction(ControlifyBindings.NEXT_SLOT.on(this.controller))) {
                this.hotbarNextRepeatHelper.onNavigate();
                inventory.setSelectedHotbarSlot((inventory.selected + 1) % Inventory.getSelectionSize());
            }
            if (this.hotbarPrevRepeatHelper.shouldAction(ControlifyBindings.PREV_SLOT.on(this.controller))) {
                this.hotbarPrevRepeatHelper.onNavigate();
                inventory.setSelectedHotbarSlot((inventory.selected - 1 + Inventory.getSelectionSize()) % Inventory.getSelectionSize());
            }
            if (!this.minecraft.player.isSpectator()) {
                if (ControlifyBindings.DROP_STACK.on(this.controller).justPressed()) {
                    if (this.minecraft.player.drop(true)) {
                        this.minecraft.player.swing(InteractionHand.MAIN_HAND);
                    }
                } else {
                    if (ControlifyBindings.DROP_INGAME.on(this.controller).justPressed()) {
                        this.dropRepeating = true;
                    } else if (ControlifyBindings.DROP_INGAME.on(this.controller).justReleased()) {
                        this.dropRepeating = false;
                    }
                    if (this.dropRepeating && this.dropRepeatHelper.shouldAction(ControlifyBindings.DROP_INGAME.on(this.controller)) && this.minecraft.player.drop(false)) {
                        this.dropRepeatHelper.onNavigate();
                        this.minecraft.player.swing(InteractionHand.MAIN_HAND);
                    }
                }
                if (ControlifyBindings.SWAP_HANDS.on(this.controller).justPressed()) {
                    this.minecraft.player.connection.send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.ZERO, Direction.DOWN));
                }
            }
            if (ControlifyBindings.INVENTORY.on(this.controller).justPressed()) {
                if (this.minecraft.gameMode.isServerControlledInventory()) {
                    this.minecraft.player.sendOpenInventory();
                } else {
                    this.minecraft.getTutorial().onOpenInventory();
                    this.minecraft.setScreen((Screen)new InventoryScreen((Player)this.minecraft.player));
                }
            }
            if (ControlifyBindings.CHANGE_PERSPECTIVE.on(this.controller).justPressed()) {
                CameraType cameraType = this.minecraft.options.getCameraType();
                this.minecraft.options.setCameraType(this.minecraft.options.getCameraType().cycle());
                if (cameraType.isFirstPerson() != this.minecraft.options.getCameraType().isFirstPerson()) {
                    this.minecraft.gameRenderer.checkEntityPostEffect(this.minecraft.options.getCameraType().isFirstPerson() ? this.minecraft.getCameraEntity() : null);
                }
                this.minecraft.levelRenderer.needsUpdate();
            }
        }
        if (ControlifyBindings.TOGGLE_HUD_VISIBILITY.on(this.controller).justPressed()) {
            boolean bl = this.minecraft.options.hideGui = !this.minecraft.options.hideGui;
        }
        if (ControlifyBindings.SHOW_PLAYER_LIST.on(this.controller).justPressed()) {
            boolean bl = this.shouldShowPlayerList = !this.shouldShowPlayerList;
        }
        if (ControlifyBindings.TOGGLE_DEBUG_MENU.on(this.controller).justPressed()) {
            DebugOverlayHelper.toggleOverlay();
        }
        if (ControlifyBindings.TOGGLE_DEBUG_MENU_FPS.on(this.controller).justPressed()) {
            DebugOverlayHelper.toggleFpsOverlay();
        }
        if (ControlifyBindings.TOGGLE_DEBUG_MENU_NET.on(this.controller).justPressed()) {
            DebugOverlayHelper.toggleNetworkOverlay();
        }
        if (ControlifyBindings.TOGGLE_DEBUG_MENU_PROF.on(this.controller).justPressed()) {
            DebugOverlayHelper.toggleProfilerOverlay();
        }
        if (ControlifyBindings.DEBUG_RADIAL.on(this.controller).justPressed()) {
            this.minecraft.setScreen((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.DEBUG_RADIAL.on(this.controller), RadialItems.createDebug(), (Component)Component.empty(), null, null));
        }
        if (ControlifyBindings.TAKE_SCREENSHOT.on(this.controller).justPressed()) {
            File screenshotFile = ScreenshotAccessor.invokeGetFile(new File(this.minecraft.gameDirectory, "screenshots"));
            Screenshot.grab((File)this.minecraft.gameDirectory, (RenderTarget)this.minecraft.getMainRenderTarget(), component -> this.minecraft.execute(() -> {
                this.minecraft.gui.getChat().addMessage(component);
                SteamDeckDriver.getDeck().ifPresent(deck -> deck.doSteamScreenshot(screenshotFile.getAbsoluteFile().toPath(), ""));
            }));
        }
        if (ControlifyBindings.PICK_BLOCK.on(this.controller).justPressed()) {
            ((PickBlockAccessor)this.minecraft).controlify$pickBlock();
        }
        if (ControlifyBindings.PICK_BLOCK_NBT.on(this.controller).justPressed()) {
            ((PickBlockAccessor)this.minecraft).controlify$pickBlockWithNbt();
        }
        if (ControlifyBindings.RADIAL_MENU.on(this.controller).justPressed()) {
            this.minecraft.setScreen((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.RADIAL_MENU.on(this.controller), RadialItems.createBindings(this.controller), (Component)Component.translatable((String)"controlify.radial_menu.configure_hint"), null, null));
        }
        if (ControlifyBindings.GAME_MODE_SWITCHER.on(this.controller).justPressed()) {
            this.minecraft.setScreen((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.GAME_MODE_SWITCHER.on(this.controller), RadialItems.createGameModes(), (Component)Component.empty(), null, null));
        }
        if (ControlifyBindings.HOTBAR_SLOT_SELECT.on(this.controller).justPressed()) {
            this.minecraft.setScreen((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.HOTBAR_SLOT_SELECT.on(this.controller), RadialItems.createHotbarItemSelect(), (Component)Component.empty(), null, null));
        }
        if (this.minecraft.gameMode.hasInfiniteItems()) {
            if (ControlifyBindings.HOTBAR_LOAD_RADIAL.on(this.controller).justPressed()) {
                this.minecraft.setScreen((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.HOTBAR_LOAD_RADIAL.on(this.controller), RadialItems.createHotbarLoad(), (Component)Component.translatable((String)"controlify.radial.hotbar_load_hint"), null, null));
            }
            if (ControlifyBindings.HOTBAR_SAVE_RADIAL.on(this.controller).justPressed()) {
                this.minecraft.setScreen((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.HOTBAR_SAVE_RADIAL.on(this.controller), RadialItems.createHotbarSave(), (Component)Component.translatable((String)"controlify.radial.hotbar_save_hint"), null, null));
            }
        }
    }

    protected void handlePlayerLookInput(boolean isController) {
        LocalPlayer player = this.minecraft.player;
        if (!isController || !this.canProcessLookInput()) {
            this.lookInputX = 0.0;
            this.lookInputY = 0.0;
            return;
        }
        boolean aiming = this.isAiming((Player)player);
        Vector2d lookImpulse = new Vector2d();
        this.controller.gyro().ifPresent(gyro -> this.handleGyroLook((GyroComponent)gyro, lookImpulse, aiming));
        if (this.controller.gyro().map(gyro -> ((GyroComponent.Config)gyro.confObj()).lookSensitivity > 0.0f && ((GyroComponent.Config)gyro.confObj()).flickStick).orElse(false).booleanValue()) {
            this.handleFlickStick(player);
        } else {
            this.controller.input().ifPresent(input -> this.handleRegularLook((InputComponent)input, lookImpulse, aiming, player));
        }
        LookInputModifier modifier = new LookInputModifier(new Vector2f((float)lookImpulse.x, (float)lookImpulse.y), this.controller);
        ControlifyEvents.LOOK_INPUT_MODIFIER.invoke(modifier);
        lookImpulse.set((Vector2fc)modifier.lookInput());
        this.lookInputX = lookImpulse.x;
        this.lookInputY = lookImpulse.y;
        this.wasAiming = aiming;
    }

    protected void handleRegularLook(InputComponent input, Vector2d impulse, boolean aiming, LocalPlayer player) {
        InputComponent.Config config = (InputComponent.Config)input.confObj();
        Vector2d regularImpulse = new Vector2d((double)(ControlifyBindings.LOOK_RIGHT.on(this.controller).analogueNow() - ControlifyBindings.LOOK_LEFT.on(this.controller).analogueNow()), (double)(ControlifyBindings.LOOK_DOWN.on(this.controller).analogueNow() - ControlifyBindings.LOOK_UP.on(this.controller).analogueNow()));
        if (config.vLookInvert) {
            regularImpulse.y *= -1.0;
        }
        if (!config.isLCE) {
            ControllerUtils.applyEasingToLength(regularImpulse, d -> d * Math.abs(d));
        } else {
            regularImpulse.x *= Math.abs(regularImpulse.x);
            regularImpulse.y *= Math.abs(regularImpulse.y);
        }
        if (config.reduceAimingSensitivity && player.isUsingItem()) {
            float f;
            if (config.isLCE) {
                switch (player.getUseItem().getUseAnimation()) {
                    case BOW: 
                    case CROSSBOW: 
                    case SPEAR: 
                    case SPYGLASS: {
                        f = 0.15f;
                        break;
                    }
                    default: {
                        f = 1.0f;
                        break;
                    }
                }
            } else {
                switch (player.getUseItem().getUseAnimation()) {
                    case BOW: 
                    case CROSSBOW: 
                    case SPEAR: {
                        f = 0.6f;
                        break;
                    }
                    case SPYGLASS: {
                        f = 0.2f;
                        break;
                    }
                    default: {
                        f = 1.0f;
                    }
                }
            }
            float aimMultiplier = f;
            regularImpulse.mul((double)aimMultiplier);
        }
        regularImpulse.x *= (double)(config.hLookSensitivity * 10.0f);
        regularImpulse.y *= (double)(config.vLookSensitivity * 10.0f);
        impulse.add((Vector2dc)regularImpulse);
    }

    protected void handleGyroLook(GyroComponent gyro, Vector2d impulse, boolean aiming) {
        GyroComponent.Config config = (GyroComponent.Config)gyro.confObj();
        InputBinding gyroButton = ControlifyBindings.GYRO_BUTTON.on(this.controller);
        if (config.requiresButton.equals((Object)GyroButtonMode.ON) && !gyroButton.digitalNow() && !aiming) {
            this.gyroInput.set(0.0f);
        } else if (config.requiresButton.equals((Object)GyroButtonMode.INVERT) && gyroButton.digitalNow() && !aiming) {
            this.gyroInput.set(0.0f);
        } else if (config.requiresButton.equals((Object)GyroButtonMode.TOGGLE) && !this.gyroToggledOn && !aiming) {
            this.gyroInput.set(0.0f);
        } else if (config.relativeGyroMode) {
            this.gyroInput.add(new GyroState(gyro.getState()).mul(0.1f));
        } else {
            this.gyroInput.set(gyro.getState());
        }
        if (config.requiresButton.equals((Object)GyroButtonMode.TOGGLE) && gyroButton.justPressed()) {
            this.gyroToggledOn = !this.gyroToggledOn;
        }
        GyroState thisInput = new GyroState(this.gyroInput).mul(57.295776f).div(20.0f).mul(config.lookSensitivity);
        impulse.y = impulse.y + (double)(-thisInput.pitch() * (float)(config.invertY ? -1 : 1));
        double d = impulse.x;
        impulse.x = d + (double)((switch (config.yawMode) {
            default -> throw new MatchException(null, null);
            case GyroYawMode.YAW -> -thisInput.yaw();
            case GyroYawMode.ROLL -> -thisInput.roll();
            case GyroYawMode.BOTH -> -thisInput.yaw() - thisInput.roll();
        }) * (float)(config.invertX ? -1 : 1));
    }

    protected void handleFlickStick(LocalPlayer player) {
        float y = ControlifyBindings.LOOK_DOWN.on(this.controller).analogueNow() - ControlifyBindings.LOOK_UP.on(this.controller).analogueNow();
        float x = ControlifyBindings.LOOK_RIGHT.on(this.controller).analogueNow() - ControlifyBindings.LOOK_LEFT.on(this.controller).analogueNow();
        float flickAngle = Mth.wrapDegrees((float)((float)Mth.atan2((double)y, (double)x) * 57.295776f + 90.0f));
        if (!(ControlifyBindings.LOOK_DOWN.on(this.controller).justPressed() || ControlifyBindings.LOOK_UP.on(this.controller).justPressed() || ControlifyBindings.LOOK_LEFT.on(this.controller).justPressed() || ControlifyBindings.LOOK_RIGHT.on(this.controller).justPressed())) {
            return;
        }
        if (this.flickAnimation != null && this.flickAnimation.isPlaying()) {
            this.flickAnimation.skipToEnd();
        }
        this.flickAnimation = Animation.of(8).easing(EasingFunction.EASE_OUT_EXPO).deltaConsumerD(angle -> player.turn(angle.doubleValue(), 0.0), 0.0, (double)flickAngle / 0.15).play();
    }

    public void processPlayerLook(float deltaTime) {
        if (this.minecraft.player != null) {
            double velX = this.lookInputX / 0.15 * (double)deltaTime;
            double velY = this.lookInputY / 0.15 * (double)deltaTime;
            this.minecraft.player.turn(velX, velY);
            this.minecraft.getTutorial().onMouse(velX, velY);
        }
    }

    public boolean shouldShowPlayerList() {
        return this.shouldShowPlayerList;
    }

    public void preventFlyDrifting() {
        if (!this.controller.genericConfig().config().disableFlyDrifting || !ServerPolicies.DISABLE_FLY_DRIFTING.get()) {
            return;
        }
        LocalPlayer player = this.minecraft.player;
        if (player != null && player.getAbilities().flying && !player.onGround()) {
            Vec3 motion = player.getDeltaMovement();
            double x = motion.x;
            double y = motion.y;
            double z = motion.z;
            boolean jumping = player.input.keyPresses.jump();
            boolean shiftKeyDown = player.input.keyPresses.shift();
            if (!jumping) {
                y = Math.min(y, 0.0);
            }
            if (!shiftKeyDown) {
                y = Math.max(y, 0.0);
            }
            Vec2 moveVec = InGameInputHandler.getMoveVec(player.input);
            if (moveVec.x == 0.0f && moveVec.y == 0.0f) {
                x = 0.0;
                z = 0.0;
            }
            player.setDeltaMovement(x, y, z);
        }
    }

    private boolean isAiming(Player player) {
        boolean bl;
        block4: {
            block3: {
                if (!player.isUsingItem()) break block3;
                switch (player.getUseItem().getUseAnimation()) {
                    case BOW: 
                    case CROSSBOW: 
                    case SPEAR: 
                    case SPYGLASS: {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    private boolean canProcessLookInput() {
        boolean mouseNotGrabbed = !this.minecraft.mouseHandler.isMouseGrabbed() && !this.controlify.config().globalSettings().outOfFocusInput;
        boolean outOfFocus = !this.minecraft.isWindowActive() && !this.controlify.config().globalSettings().outOfFocusInput;
        boolean screenVisible = this.minecraft.screen != null;
        boolean playerExists = this.minecraft.player != null;
        return !mouseNotGrabbed && !outOfFocus && !screenVisible && playerExists;
    }

    public static Vec2 getMoveVec(ClientInput input) {
        return new Vec2(input.leftImpulse, input.forwardImpulse);
    }
}

