/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.guide.screen;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.gui.ButtonGuideRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractWidget.class})
public abstract class AbstractWidgetMixin
implements ButtonGuideRenderer<AbstractWidget>,
NarratableEntry {
    @Unique
    private ButtonGuideRenderer.RenderData<AbstractWidget> renderData = null;
    @Unique
    private final Map<InputBinding, Component> controllerMessages = new Object2ObjectArrayMap(2);

    @Shadow
    public abstract int getX();

    @Shadow
    public abstract int getY();

    @Shadow
    public abstract int getHeight();

    @Shadow
    public abstract int getWidth();

    @Shadow
    public abstract Component getMessage();

    @Shadow
    public abstract boolean isActive();

    @Inject(method={"setMessage"}, at={@At(value="RETURN")})
    protected void catchMessageSet(Component message, CallbackInfo ci) {
        this.controllerMessages.clear();
    }

    @ModifyExpressionValue(method={"renderScrollingString(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/AbstractWidget;getMessage()Lnet/minecraft/network/chat/Component;")})
    protected Component modifyRenderedMessage(Component actualMessage) {
        return this.getControllerMessage(actualMessage);
    }

    @Override
    public void controlify$setButtonGuide(ButtonGuideRenderer.RenderData<AbstractWidget> renderData) {
        this.renderData = renderData;
        this.controllerMessages.clear();
    }

    @Unique
    private Component getControllerMessage(Component actualLabel) {
        if (!this.shouldRender()) {
            return actualLabel;
        }
        return this.getBind().map(bind -> this.controllerMessages.computeIfAbsent((InputBinding)bind, b -> this.renderData.getControllerMessage((InputBinding)b, actualLabel))).orElse(actualLabel);
    }

    @Unique
    protected boolean shouldRender() {
        return this.renderData != null && this.isActive() && this.renderData.shouldRender((AbstractWidget)this);
    }

    @Unique
    private Optional<InputBinding> getBind() {
        if (this.renderData == null) {
            return Optional.empty();
        }
        return this.renderData.getBind();
    }
}

