/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.rumble.levelevents;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.rumble.BasicRumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.utils.Easings;
import net.minecraft.client.renderer.LevelEventHandler;
import net.minecraft.core.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelEventHandler.class})
public class LevelEventHandlerMixin {
    @Inject(method={"levelEvent"}, at={@At(value="HEAD")})
    private void onLevelEvent(int eventId, BlockPos pos, int data, CallbackInfo ci) {
        switch (eventId) {
            case 1030: {
                ControlifyApi.get().playRumbleEffect(RumbleSource.GUI, BasicRumbleEffect.join(BasicRumbleEffect.constant(1.0f, 0.5f, 2), BasicRumbleEffect.empty(5)).repeat(3));
            }
        }
    }

    @Inject(method={"globalLevelEvent"}, at={@At(value="HEAD")})
    private void onGlobalLevelEvent(int eventId, BlockPos pos, int data, CallbackInfo ci) {
        switch (eventId) {
            case 1028: {
                ControlifyApi.get().playRumbleEffect(RumbleSource.WORLD, BasicRumbleEffect.join(BasicRumbleEffect.constant(1.0f, 1.0f, 194), BasicRumbleEffect.byTime(t -> {
                    float easeOutQuad = (float)Easings.easeOutQuad(t.floatValue());
                    return new RumbleState(1.0f - easeOutQuad, 1.0f - easeOutQuad);
                }, 63)).prioritised(10));
                break;
            }
            case 1023: {
                ControlifyApi.get().playRumbleEffect(RumbleSource.WORLD, BasicRumbleEffect.join(BasicRumbleEffect.constant(1.0f, 1.0f, 9), BasicRumbleEffect.constant(0.1f, 1.0f, 14), BasicRumbleEffect.byTime(t -> {
                    float easeOutQuad = 1.0f - (1.0f - t.floatValue()) * (1.0f - t.floatValue());
                    return new RumbleState(0.0f, 1.0f - easeOutQuad);
                }, 56)).prioritised(10));
            }
        }
    }
}

