/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.screenop.impl.elements;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ComponentProcessorProvider;
import dev.isxander.controlify.screenop.compat.vanilla.EditBoxComponentProcessor;
import dev.isxander.controlify.screenop.keyboard.CommonKeyboardHints;
import dev.isxander.controlify.screenop.keyboard.ComponentKeyboardBehaviour;
import dev.isxander.controlify.screenop.keyboard.KeyboardOverlayScreen;
import dev.isxander.controlify.utils.LazyComponentDims;
import dev.isxander.controlify.utils.render.CGuiPose;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EditBox.class})
public abstract class EditBoxMixin
extends AbstractWidget
implements ComponentProcessorProvider {
    @Shadow
    @Nullable
    private Component hint;
    @Shadow
    @Nullable
    private String suggestion;
    @Shadow
    @Final
    private Font font;
    @Unique
    private final EditBoxComponentProcessor processor = new EditBoxComponentProcessor((EditBox)this, Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());

    @Shadow
    public abstract boolean isBordered();

    public EditBoxMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @ModifyExpressionValue(method={"renderWidget"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;plainSubstrByWidth(Ljava/lang/String;I)Ljava/lang/String;")})
    private String renderHintText(String renderedValue, @Local(argsOnly=true) GuiGraphics graphics, @Share(value="renderHint") LocalBooleanRef renderHint) {
        renderHint.set(false);
        ControlifyApi.get().getCurrentController().ifPresent(controller -> {
            if (this.isFocused() && controller.genericConfig().config().showOnScreenKeyboard && controller.genericConfig().config().showScreenGuides && ControlifyApi.get().currentInputMode().isController() && !(Minecraft.getInstance().screen instanceof KeyboardOverlayScreen) && this.processor.getKeyboardBehaviour() instanceof ComponentKeyboardBehaviour.Handled) {
                int textX = this.getX() + (this.isBordered() ? 2 : 0) + 2;
                int textY = this.getY() + (this.isBordered() ? 2 : 0) + 4;
                if (renderedValue.isEmpty() && this.hint == null && this.suggestion == null) {
                    LazyComponentDims component = CommonKeyboardHints.OPEN_KEYBOARD;
                    int width = component.getWidth();
                    CGuiPose pose = CGuiPose.ofPush(graphics);
                    if (width > this.getWidth() + (this.isBordered() ? 4 : 0)) {
                        pose.translate(textX, textY + 3);
                        pose.scale(0.5f, 0.5f);
                        pose.translate(-textX, -textY - 3);
                    }
                    renderHint.set(true);
                    graphics.drawString(this.font, component.getComponent(), textX, textY, -5592406);
                    pose.pop();
                } else {
                    Component component = ControlifyBindings.GUI_PRESS.inputGlyph();
                    int width = this.font.width((FormattedText)component);
                    graphics.drawString(this.font, component, this.getRight() - 2 - width, textY, -1);
                }
            }
        });
        return renderedValue;
    }

    @ModifyExpressionValue(method={"renderWidget"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="isFocused", method={"Lnet/minecraft/client/gui/components/EditBox;isFocused()Z"}), @Definition(id="getMillis", method={"Lnet/minecraft/Util;getMillis()J"}), @Definition(id="focusedTime", field={"Lnet/minecraft/client/gui/components/EditBox;focusedTime:J"})})
    @Expression(value={"(getMillis() - this.focusedTime) / 300 % 2 == 0"})
    private boolean preventShowingCursor(boolean showCursor, @Share(value="renderHint") LocalBooleanRef renderHint) {
        return showCursor && !renderHint.get();
    }

    @Override
    public ComponentProcessor componentProcessor() {
        return this.processor;
    }
}

