/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.keyboard.CommonKeyboardHints;
import dev.isxander.controlify.screenop.keyboard.KeyboardWidget;
import dev.isxander.controlify.utils.LazyComponentDims;
import dev.isxander.controlify.utils.PrecomputedComponentDims;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class AbstractSignEditScreenProcessor
extends ScreenProcessor<AbstractSignEditScreen> {
    private static final Component signLineHint = Component.translatable((String)"controlify.hint.sign_line_change", (Object[])new Object[]{ControlifyBindings.GUI_SECONDARY_NAVI_UP.inputGlyph(), ControlifyBindings.GUI_SECONDARY_NAVI_DOWN.inputGlyph()});
    private final Consumer<Integer> moveCursorFunc;
    private final Supplier<SignBlockEntity> signSupplier;
    private final Supplier<KeyboardWidget> keyboardWidgetSupplier;
    private List<PrecomputedComponentDims<FormattedCharSequence>> signLineHintLines;

    public AbstractSignEditScreenProcessor(AbstractSignEditScreen screen, Consumer<Integer> moveCursorFunc, Supplier<SignBlockEntity> signSupplier, Supplier<KeyboardWidget> keyboardWidgetSupplier) {
        super(screen);
        this.moveCursorFunc = moveCursorFunc;
        this.signSupplier = signSupplier;
        this.keyboardWidgetSupplier = keyboardWidgetSupplier;
    }

    @Override
    protected void handleButtons(ControllerEntity controller) {
        super.handleButtons(controller);
        GenericControllerConfig config = controller.genericConfig().config();
        if (ControlifyBindings.GUI_SECONDARY_NAVI_DOWN.on(controller).justPressed()) {
            this.moveCursorFunc.accept(1);
            if (config.hintKeyboardSignLine && config.showScreenGuides) {
                config.hintKeyboardSignLine = false;
                Controlify.instance().config().save();
            }
            AbstractSignEditScreenProcessor.playFocusChangeSound();
        }
        if (ControlifyBindings.GUI_SECONDARY_NAVI_UP.on(controller).justPressed()) {
            this.moveCursorFunc.accept(-1);
            if (config.hintKeyboardSignLine && config.showScreenGuides) {
                config.hintKeyboardSignLine = false;
                Controlify.instance().config().save();
            }
            AbstractSignEditScreenProcessor.playFocusChangeSound();
        }
    }

    @Override
    protected void render(ControllerEntity controller, GuiGraphics graphics, float tickDelta, Optional<VirtualMouseHandler> vmouse) {
        GenericControllerConfig config = controller.genericConfig().config();
        KeyboardWidget keyboardWidget = this.keyboardWidgetSupplier.get();
        if (keyboardWidget != null && config.showScreenGuides) {
            if (config.hintKeyboardCursor) {
                LazyComponentDims hint = CommonKeyboardHints.TEXT_CURSOR;
                int x = keyboardWidget.getRight() - hint.getWidth() - 2;
                int y = keyboardWidget.getY() - hint.getHeight();
                graphics.drawString(AbstractSignEditScreenProcessor.minecraft.font, hint.getComponent(), x, y, -1, true);
            }
            if (config.hintKeyboardSignLine && this.signLineHintLines != null) {
                int y = 4;
                for (PrecomputedComponentDims<FormattedCharSequence> line : this.signLineHintLines) {
                    int lineWidth = line.width();
                    int lineHeight = line.height();
                    FormattedCharSequence lineText = line.component();
                    graphics.drawString(AbstractSignEditScreenProcessor.minecraft.font, lineText, ((AbstractSignEditScreen)this.screen).width - 1 - lineWidth, y, -1, true);
                    Objects.requireNonNull(AbstractSignEditScreenProcessor.minecraft.font);
                    y += 9;
                }
            }
        }
    }

    @Override
    protected void setInitialFocus() {
        if (Controlify.instance().currentInputMode() == InputMode.MIXED) {
            this.holdRepeatHelper.clearDelay();
        } else {
            super.setInitialFocus();
        }
    }

    @Override
    public void onWidgetRebuild() {
        super.onWidgetRebuild();
        this.getWidget(CommonComponents.GUI_DONE).ifPresent(doneButton -> ButtonGuideApi.addGuideToButton((AbstractButton)doneButton, ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always()));
        SignBlockEntity sign = this.signSupplier.get();
        int signRight = ((AbstractSignEditScreen)this.screen).width / 2 + sign.getMaxTextLineWidth() / 2;
        int maxLineWidth = ((AbstractSignEditScreen)this.screen).width - signRight;
        this.signLineHintLines = AbstractSignEditScreenProcessor.minecraft.font.split((FormattedText)signLineHint, maxLineWidth).stream().map(cs -> PrecomputedComponentDims.of(cs, AbstractSignEditScreenProcessor.minecraft.font)).toList();
    }
}

