/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;

public class BundleItemSlotControllerAction {
    public static boolean onControllerInput(ItemStack stack, int hoveredSlotIndex, ControllerEntity controller, SelectedBundleItemConsumer consumer) {
        int uniqueItems = BundleItem.getNumberOfItemsToShow((ItemStack)stack);
        if (uniqueItems > 0) {
            Controlify.instance().virtualMouseHandler().preventScrollingThisTick();
            boolean up = ControlifyBindings.GUI_SECONDARY_NAVI_UP.on(controller).justPressed();
            boolean down = ControlifyBindings.GUI_SECONDARY_NAVI_DOWN.on(controller).justPressed();
            boolean left = ControlifyBindings.GUI_SECONDARY_NAVI_LEFT.on(controller).justPressed();
            boolean right = ControlifyBindings.GUI_SECONDARY_NAVI_RIGHT.on(controller).justPressed();
            int offsetX = 0;
            int offsetY = 0;
            if (up) {
                --offsetY;
            }
            if (down) {
                ++offsetY;
            }
            if (left) {
                --offsetX;
            }
            if (right) {
                ++offsetX;
            }
            if (offsetX != 0 || offsetY != 0) {
                int currentIndex = BundleItem.getSelectedItem((ItemStack)stack);
                if (currentIndex == -1) {
                    consumer.accept(stack, hoveredSlotIndex, 0);
                    return true;
                }
                int rowSize = 4;
                int colSize = Math.min(Mth.ceil((float)((float)uniqueItems / (float)rowSize)), 3);
                int incompleteRowSize = uniqueItems % rowSize;
                int emptySlots = (rowSize - incompleteRowSize) % rowSize;
                int gridX = (currentIndex + emptySlots) % rowSize;
                int gridY = (currentIndex + emptySlots) / rowSize;
                int newGridX = (gridX + offsetX + rowSize) % rowSize;
                int newGridY = (gridY + offsetY + colSize) % colSize;
                if (newGridY >= 0 && newGridY < colSize) {
                    int newIndex = Math.max(newGridX + newGridY * rowSize - emptySlots, 0);
                    consumer.accept(stack, hoveredSlotIndex, newIndex);
                }
                return true;
            }
        }
        return false;
    }

    public static interface SelectedBundleItemConsumer {
        public void accept(ItemStack var1, int var2, int var3);
    }
}

