/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessor;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;

public class TitleScreenProcessor
extends ScreenProcessor<TitleScreen> {
    public TitleScreenProcessor(TitleScreen screen) {
        super(screen);
    }

    @Override
    protected void handleButtons(ControllerEntity controller) {
        if (ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
            ((TitleScreen)this.screen).setFocused((GuiEventListener)this.getWidget("menu.quit").orElseThrow());
            TitleScreenProcessor.playClackSound();
        }
        super.handleButtons(controller);
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_1.on(controller).justPressed()) {
            minecraft.setScreen((Screen)new OptionsScreen(this.screen, TitleScreenProcessor.minecraft.options));
            TitleScreenProcessor.playClackSound();
        }
    }

    @Override
    public void onWidgetRebuild() {
        super.onWidgetRebuild();
        AbstractButton quitButton = (AbstractButton)this.getWidget("menu.quit").orElseThrow();
        ButtonGuideApi.addGuideToButton(quitButton, () -> quitButton.isFocused() ? ControlifyBindings.GUI_PRESS : ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always());
        ButtonGuideApi.addGuideToButton((AbstractButton)this.getWidget("menu.options").orElseThrow(), ControlifyBindings.GUI_ABSTRACT_ACTION_1, ButtonGuidePredicate.always());
    }
}

