/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.controllers;

import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.utils.render.elements.CircleElementRenderState;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class Deadzone2DImageRenderer
implements ImageRenderer {
    private final InputComponent input;
    private final DeadzoneGroup deadzoneGroup;
    private final Supplier<Option<Float>> deadzoneOption;

    public Deadzone2DImageRenderer(InputComponent input, DeadzoneGroup deadzoneGroup, Supplier<Option<Float>> deadzoneOption) {
        this.input = input;
        this.deadzoneGroup = deadzoneGroup;
        this.deadzoneOption = deadzoneOption;
    }

    public int render(class_332 graphics, int x, int y, int renderWidth, float tickDelta) {
        float radius = (float)renderWidth / 4.0f;
        int renderHeight = (int)(radius * 2.0f);
        List<class_2960> deadzones = this.deadzoneGroup.axes();
        float up = this.input.rawStateNow().getAxisState(deadzones.get(0));
        float down = this.input.rawStateNow().getAxisState(deadzones.get(1));
        float left = this.input.rawStateNow().getAxisState(deadzones.get(2));
        float right = this.input.rawStateNow().getAxisState(deadzones.get(3));
        float currentX = right - left;
        float currentY = down - up;
        graphics.method_25292(x, (int)((float)x + radius * 2.0f), (int)((float)y + radius), -5592406);
        graphics.method_25301((int)((float)x + radius), y, (int)((float)y + radius * 2.0f), -5592406);
        CircleElementRenderState.outline(graphics, (float)x + radius, (float)y + radius, radius, 1.0f, -1).submit(graphics);
        float deadzone = ((Float)this.deadzoneOption.get().pendingValue()).floatValue();
        boolean aboveDeadzone = Math.abs(currentX) > deadzone || Math.abs(currentY) > deadzone;
        CircleElementRenderState.outline(graphics, (float)x + radius, (float)y + radius, deadzone * radius, 1.0f, aboveDeadzone ? -16711681 : -65536).submit(graphics);
        CircleElementRenderState.filled(graphics, (float)x + radius + currentX * radius, (float)y + radius + currentY * radius, 1.0f, -16711936).submit(graphics);
        class_327 font = class_310.method_1551().field_1772;
        DecimalFormat format = new DecimalFormat("0.000");
        graphics.method_25303(font, "X: " + format.format(currentX), (int)((float)x + radius * 2.0f + 5.0f), y, -1);
        String string = "Y: " + format.format(currentY);
        int n = (int)((float)x + radius * 2.0f + 5.0f);
        Objects.requireNonNull(font);
        graphics.method_25303(font, string, n, y + 9 + 1, -1);
        return renderHeight;
    }

    public void close() {
    }
}

