/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.platform.main.fabric;

import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.platform.Environment;
import dev.isxander.controlify.platform.main.PlatformMainUtilImpl;
import dev.isxander.controlify.platform.main.events.CommandRegistrationCallbackEvent;
import dev.isxander.controlify.platform.main.events.HandshakeCompletionEvent;
import dev.isxander.controlify.platform.main.events.PlayerJoinedEvent;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public class FabricPlatformMainImpl
implements PlatformMainUtilImpl {
    @Override
    public void registerCommandRegistrationCallback(CommandRegistrationCallbackEvent callback) {
        CommandRegistrationCallback.EVENT.register(callback::onRegister);
    }

    @Override
    public void registerInitPlayConnectionEvent(PlayerJoinedEvent event) {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> event.onInit(handler.method_32311()));
    }

    @Override
    public boolean isModLoaded(String ... modIds) {
        return Arrays.stream(modIds).anyMatch(arg_0 -> ((FabricLoader)FabricLoader.getInstance()).isModLoaded(arg_0));
    }

    @Override
    public void applyToControlifyEntrypoint(Consumer<ControlifyEntrypoint> entrypointConsumer) {
        FabricLoader.getInstance().getEntrypoints("controlify", ControlifyEntrypoint.class).forEach(entrypointConsumer);
    }

    @Override
    public <I, O> void setupServersideHandshake(class_2960 handshakeId, class_9139<class_2540, I> serverBoundCodec, class_9139<class_2540, O> clientBoundCodec, Supplier<O> packetCreator, HandshakeCompletionEvent<I> completionEvent) {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            Object decodedPacket = packetCreator.get();
            class_2540 encodedPacket = PacketByteBufs.create();
            clientBoundCodec.encode((Object)encodedPacket, decodedPacket);
            sender.sendPacket(handshakeId, encodedPacket);
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)handshakeId, (server, handler, understood, buf, synchronizer, responseSender) -> {
            Object decodedPacket = understood ? serverBoundCodec.decode((Object)buf) : null;
            completionEvent.onCompletion(decodedPacket, handler);
        });
    }

    @Override
    public <T> Supplier<T> deferredRegister(class_2378<T> registry, class_2960 id, Supplier<? extends T> registrant) {
        Object registered = class_2378.method_10230(registry, (class_2960)id, registrant.get());
        return () -> registered;
    }

    @Override
    public Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isDevEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public Environment getEnv() {
        return switch (FabricLoader.getInstance().getEnvironmentType()) {
            default -> throw new MatchException(null, null);
            case EnvType.CLIENT -> Environment.CLIENT;
            case EnvType.SERVER -> Environment.SERVER;
        };
    }

    @Override
    public String getControlifyVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("controlify").orElseThrow()).getMetadata().getVersion().getFriendlyString();
    }
}

