/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.compatibility;

import dev.isxander.controlify.compatibility.fancymenu.FancyMenuCompat;
import dev.isxander.controlify.compatibility.simplevoicechat.SimpleVoiceChatCompat;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.utils.CUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Util;

public class ControlifyCompat {
    private static final Function<String, Boolean> modsLoaded = Util.memoize(modid -> PlatformMainUtil.isModLoaded(modid));
    private static final Set<String> disabledMods = new HashSet<String>();
    public static final String IMMEDIATELY_FAST = "immediatelyfast";
    public static final String SIMPLE_VOICE_CHAT = "voicechat";
    public static final String FANCY_MENU = "fancymenu";

    public static void init() {
        try {
            ControlifyCompat.wrapCompatCall(SIMPLE_VOICE_CHAT, SimpleVoiceChatCompat::init);
        }
        catch (NoClassDefFoundError e) {
            disabledMods.add(SIMPLE_VOICE_CHAT);
        }
        try {
            ControlifyCompat.wrapCompatCall(FANCY_MENU, FancyMenuCompat::registerActions);
        }
        catch (NoClassDefFoundError e) {
            disabledMods.add(FANCY_MENU);
        }
    }

    private static void wrapCompatCall(String modid, Runnable runnable) throws NoClassDefFoundError {
        if (modsLoaded.apply(modid).booleanValue() && !disabledMods.contains(modid)) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                CUtil.LOGGER.error("Failed to run compatibility code for {}, potentially unsupported version? Disabling '{}' compat for this instance.", modid, modid, t);
                disabledMods.add(modid);
            }
        }
    }
}

