/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.gyro.GyroState;
import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.utils.ClientUtils;
import dev.isxander.controlify.utils.render.CGuiPose;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ControllerCalibrationScreen
extends Screen
implements DontInteruptScreen {
    private static final int CALIBRATION_TIME = 100;
    protected final Controlify controlify;
    protected final ControllerManager controllerManager;
    protected final ControllerEntity controller;
    private final Supplier<Screen> parent;
    private MultiLineLabel waitLabel;
    private MultiLineLabel infoLabel;
    private MultiLineLabel completeLabel;
    protected Button readyButton;
    protected Button laterButton;
    protected boolean calibrating = false;
    protected boolean calibrated = false;
    protected int calibrationTicks = 0;
    @Nullable
    private final Map<ResourceLocation, float[]> axisData;
    private GyroState accumulatedGyroVelocity = new GyroState();

    public ControllerCalibrationScreen(ControllerEntity controller, Screen parent) {
        this(controller, () -> parent);
    }

    public ControllerCalibrationScreen(ControllerEntity controller, Supplier<Screen> parent) {
        super((Component)Component.translatable((String)"controlify.calibration.title"));
        this.controlify = Controlify.instance();
        this.controllerManager = this.controlify.getControllerManager().orElseThrow();
        this.controller = controller;
        this.parent = parent;
        Optional<InputComponent> inputOpt = controller.input();
        this.axisData = inputOpt.map(inputComponent -> new HashMap(inputComponent.axisCount())).orElse(null);
    }

    protected void init() {
        this.readyButton = Button.builder((Component)Component.translatable((String)"controlify.calibration.ready"), btn -> this.onButtonPress()).width(150).pos(this.width / 2 - 150 - 5, this.height - 8 - 20).build();
        this.addRenderableWidget((GuiEventListener)this.readyButton);
        this.laterButton = Button.builder((Component)Component.translatable((String)"controlify.calibration.later"), btn -> this.onLaterButtonPress()).width(150).pos(this.width / 2 + 5, this.height - 8 - 20).tooltip(Tooltip.create((Component)Component.translatable((String)"controlify.calibration.later.tooltip"))).build();
        this.addRenderableWidget((GuiEventListener)this.laterButton);
        this.infoLabel = MultiLineLabel.create((Font)this.font, (Component)Component.translatable((String)"controlify.calibration.info"), (int)(this.width - 30));
        this.waitLabel = MultiLineLabel.create((Font)this.font, (Component)Component.translatable((String)"controlify.calibration.wait"), (int)(this.width - 30));
        this.completeLabel = MultiLineLabel.create((Font)this.font, (Component)Component.translatable((String)"controlify.calibration.complete"), (int)(this.width - 30));
    }

    protected void startCalibration() {
        this.calibrating = true;
        this.readyButton.active = false;
        this.readyButton.setMessage((Component)Component.translatable((String)"controlify.calibration.calibrating"));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"controlify.calibration.title", (Object[])new Object[]{this.controller.name()}).withStyle(ChatFormatting.BOLD), this.width / 2, 8, -1);
        CGuiPose pose = CGuiPose.ofPush(graphics);
        pose.scale(2.0f, 2.0f);
        float progress = ((float)(this.calibrationTicks - 1) + delta) / 100.0f;
        progress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
        ClientUtils.drawBar(graphics, this.width / 2 / 2, 15, progress);
        pose.pop();
        MultiLineLabel label = this.calibrating ? this.waitLabel : (this.calibrated ? this.completeLabel : this.infoLabel);
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        label.render(graphics, MultiLineLabel.Align.CENTER, n, 55, 9, false, -1);
        pose.push();
        int n2 = this.readyButton.getY();
        Objects.requireNonNull(this.font);
        float scale = Math.min(3.0f, (float)(n2 - (55 + 9 * label.getLineCount()) - 2) / 64.0f);
        float f = (float)this.width / 2.0f - 32.0f * scale;
        Objects.requireNonNull(this.font);
        pose.translate(f, 55 + 9 * label.getLineCount());
        pose.scale(scale, scale);
        ClientUtils.drawSprite(graphics, this.controller.info().type().getIconSprite(), 0, 0, 64, 64);
        pose.pop();
    }

    public void tick() {
        if (!this.controllerManager.isControllerConnected(this.controller.uid())) {
            this.onClose();
            return;
        }
        if (!this.calibrating) {
            return;
        }
        if (this.stateChanged()) {
            this.calibrationTicks = 0;
            if (this.axisData != null) {
                this.axisData.clear();
            }
            this.accumulatedGyroVelocity = new GyroState();
        }
        if (this.calibrationTicks < 100) {
            this.processAxisData(this.calibrationTicks);
            this.processGyroData();
            ++this.calibrationTicks;
        } else {
            this.calibrateAxis();
            this.generateGyroCalibration();
            this.calibrating = false;
            this.calibrated = true;
            this.readyButton.active = true;
            this.readyButton.setMessage((Component)Component.translatable((String)"controlify.calibration.done"));
            this.controller.input().map(input -> input.config().config()).ifPresent(config -> {
                config.deadzonesCalibrated = true;
                config.delayedCalibration = false;
            });
            this.controller.gyro().map(gyro -> gyro.config().config()).ifPresent(config -> {
                config.calibrated = true;
            });
            Controlify.instance().config().setDirty();
            Controlify.instance().config().saveIfDirty();
        }
    }

    private void processAxisData(int tick) {
        if (this.axisData == null) {
            return;
        }
        InputComponent input = this.controller.input().orElseThrow();
        ControllerState state = input.rawStateNow();
        for (DeadzoneGroup group : input.getDeadzoneGroups().values()) {
            float[] axisData = this.axisData.computeIfAbsent(group.name(), k -> new float[100]);
            float max = 0.0f;
            for (ResourceLocation axis : group.axes()) {
                max = Math.max(max, Math.abs(state.getAxisState(axis)));
            }
            axisData[tick] = max;
        }
    }

    private void processGyroData() {
        this.controller.gyro().ifPresent(gyro -> this.accumulatedGyroVelocity.add(gyro.getState()));
    }

    private void calibrateAxis() {
        if (this.axisData == null) {
            return;
        }
        InputComponent input = this.controller.input().orElseThrow();
        input.config().config().deadzones.clear();
        for (DeadzoneGroup group : input.getDeadzoneGroups().values()) {
            float[] axisData = this.axisData.get(group.name());
            if (axisData == null) continue;
            float maxAbs = 0.0f;
            for (int tick = 0; tick < 100; ++tick) {
                float axisValue = axisData[tick];
                maxAbs = Math.max(maxAbs, Math.abs(axisValue));
            }
            input.config().config().deadzones.put(group.name(), Float.valueOf(maxAbs + 0.08f));
        }
    }

    private void generateGyroCalibration() {
        this.controller.gyro().ifPresent(gyro -> {
            gyro.config().config().calibration = this.accumulatedGyroVelocity.div(100.0f);
        });
    }

    private boolean stateChanged() {
        InputComponent input = this.controller.input().orElseThrow();
        float amt = 0.4f;
        for (ResourceLocation axis : input.rawStateNow().getAxes()) {
            float prevAxisValue;
            float axisValue;
            float[] axisData = this.axisData.get(axis);
            if (axisData == null || !(Math.abs((axisValue = input.rawStateNow().getAxisState(axis)) - (prevAxisValue = input.rawStateThen().getAxisState(axis))) > amt)) continue;
            return true;
        }
        return false;
    }

    private void onButtonPress() {
        if (!this.calibrated) {
            this.startCalibration();
            this.removeWidget((GuiEventListener)this.laterButton);
            this.readyButton.setX(this.width / 2 - 75);
        } else {
            this.onClose();
        }
    }

    private void onLaterButtonPress() {
        if (!this.calibrated) {
            boolean dirty = false;
            dirty |= this.controller.input().map(input -> {
                input.config().config().delayedCalibration = true;
                return true;
            }).orElse(false).booleanValue();
            if (dirty |= this.controller.gyro().map(gyro -> {
                gyro.config().config().delayedCalibration = true;
                return true;
            }).orElse(false).booleanValue()) {
                Controlify.instance().config().setDirty();
            }
            this.onClose();
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent.get());
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

