/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.haptic.HapticEffects;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.sound.ControlifyClientSounds;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class RadialMenuScreen
extends Screen
implements ScreenControllerEventListener,
ScreenProcessorProvider {
    public static final ResourceLocation EMPTY_ACTION = CUtil.rl("empty_action");
    private final ControllerEntity controller;
    @Nullable
    private final EditMode editMode;
    private final Screen parent;
    private final Component text;
    private final RadialItem[] items;
    private final RadialButton[] buttons;
    private float radialRadius;
    private final InputBinding openBind;
    private int selectedButton = -1;
    private int idleTicks;
    private final int idleTicksTimeout;
    private boolean isEditing;
    private ActionSelectList actionSelectList;
    private final Processor processor = new Processor(this);

    public RadialMenuScreen(ControllerEntity controller, InputBinding openBind, RadialItem[] items, Component text, @Nullable EditMode editMode, Screen parent) {
        super(text);
        this.text = text;
        this.controller = controller;
        this.items = items;
        this.buttons = new RadialButton[items.length];
        this.editMode = editMode;
        this.parent = parent;
        this.idleTicksTimeout = ((InputComponent.Config)controller.input().orElseThrow().confObj()).radialButtonFocusTimeoutTicks;
        this.openBind = openBind;
    }

    protected void init() {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        float buttonRadius = (float)Math.sqrt(2048.0) + 8.0f;
        float circumference = buttonRadius * (float)this.items.length;
        this.radialRadius = Math.max(circumference / ((float)Math.PI * 2), 43.0f);
        Animation animation = Animation.of(5).easing(EasingFunction.EASE_OUT_QUAD);
        for (int i = 0; i < this.items.length; ++i) {
            float angle = (float)Math.PI * 2 * (float)i / (float)this.items.length - 1.5707964f;
            float x = (float)centerX + Mth.cos((float)angle) * this.radialRadius;
            float y = (float)centerY + Mth.sin((float)angle) * this.radialRadius;
            RadialButton button = this.buttons[i] = new RadialButton(this.items[i], centerX - 16, centerY - 16);
            animation.consumerF(button::setX, centerX - 16, x - 16.0f).consumerF(button::setY, centerY - 16, y - 16.0f);
            this.addRenderableWidget(button);
        }
        animation.play();
        if (this.editMode != null) {
            // empty if block
        }
    }

    @Override
    public void onControllerInput(ControllerEntity controller) {
        if (this.controller != controller) {
            return;
        }
        if (this.editMode == null && !this.openBind.digitalNow()) {
            if (this.selectedButton != -1 && this.buttons[this.selectedButton].invoke()) {
                this.playClickSound();
            }
            this.onClose();
        }
        if (this.editMode != null && ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
            this.playClickSound();
            this.onClose();
        }
        if (!this.isEditing) {
            float x = ControlifyBindings.RADIAL_AXIS_RIGHT.on(controller).analogueNow() - ControlifyBindings.RADIAL_AXIS_LEFT.on(controller).analogueNow();
            float y = ControlifyBindings.RADIAL_AXIS_DOWN.on(controller).analogueNow() - ControlifyBindings.RADIAL_AXIS_UP.on(controller).analogueNow();
            float threshold = controller.input().orElseThrow().config().config().buttonActivationThreshold;
            if (Math.abs(x) >= threshold || Math.abs(y) >= threshold) {
                float each;
                float angle = Mth.wrapDegrees((float)(57.295776f * (float)Mth.atan2((double)y, (double)x) - 90.0f)) + 180.0f;
                int newSelected = Mth.floor((float)((angle + (each = 360.0f / (float)this.buttons.length) / 2.0f) / each)) % this.buttons.length;
                if (newSelected != this.selectedButton) {
                    this.selectedButton = newSelected;
                    this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)ControlifyClientSounds.SCREEN_FOCUS_CHANGE.get(), (float)1.0f));
                    controller.hdHaptics().ifPresent(haptics -> haptics.playHaptic(HapticEffects.NAVIGATE));
                }
                for (int i = 0; i < this.buttons.length; ++i) {
                    boolean selected = i == this.selectedButton;
                    this.buttons[i].setFocused(selected);
                    if (!selected) continue;
                    this.setFocused(this.buttons[i]);
                }
                this.idleTicks = 0;
            } else if (this.editMode == null) {
                ++this.idleTicks;
                if (this.idleTicks >= this.idleTicksTimeout && this.selectedButton != -1) {
                    this.selectedButton = -1;
                    for (RadialButton button : this.buttons) {
                        button.setFocused(false);
                    }
                    controller.hdHaptics().ifPresent(haptics -> haptics.playHaptic(HapticEffects.NAVIGATE));
                }
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        if (this.editMode == null) {
            graphics.drawCenteredString(this.font, this.text, this.width / 2, this.height - 39, -1);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.editMode != null) {
            super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void playClickSound() {
        this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    private void finishEditing() {
        this.isEditing = false;
        this.removeWidget((GuiEventListener)this.actionSelectList);
        this.setFocused(null);
        this.actionSelectList = null;
    }

    public void onClose() {
        Controlify.instance().config().saveIfDirty();
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return this.editMode != null;
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.processor;
    }

    public static class Processor
    extends ScreenProcessor<RadialMenuScreen> {
        public Processor(RadialMenuScreen screen) {
            super(screen);
        }

        @Override
        public VirtualMouseBehaviour virtualMouseBehaviour() {
            return VirtualMouseBehaviour.DISABLED;
        }
    }

    public static interface RadialItem {
        public Component name();

        public RadialIcon icon();

        public boolean playAction();
    }

    public class RadialButton
    implements Renderable,
    GuiEventListener,
    NarratableEntry,
    ComponentProcessor {
        public static final ResourceLocation TEXTURE = CUtil.rl("textures/gui/radial-buttons.png");
        private int x;
        private int y;
        private float translateX;
        private float translateY;
        private boolean focused;
        private RadialItem item;
        private MultiLineLabel name;

        private RadialButton(RadialItem item, float x, float y) {
            this.setX(x);
            this.setY(y);
            this.setAction(item);
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            CGuiPose pose = CGuiPose.ofPush(graphics);
            pose.translate((float)this.x + this.translateX, (float)this.y + this.translateY);
            pose.push();
            pose.scale(2.0f, 2.0f);
            Blit.tex(graphics, TEXTURE, 0, 0, this.focused ? 16 : 0, 0, 16, 16, 32, 16);
            pose.pop();
            if (RadialMenuScreen.this.editMode == null || !this.focused) {
                pose.push();
                pose.translate(4.0f, 4.0f);
                pose.scale(1.5f, 1.5f);
                this.item.icon().draw(graphics, 0, 0, delta);
                pose.pop();
            } else {
                Component bind = ControlifyBindings.GUI_PRESS.on(RadialMenuScreen.this.controller).inputGlyph();
                Font font = RadialMenuScreen.this.font;
                int n = 16 - RadialMenuScreen.this.font.width((FormattedText)bind) / 2;
                Objects.requireNonNull(RadialMenuScreen.this.font);
                graphics.drawString(font, bind, n, 16 - 9 / 2, -1);
            }
            pose.pop();
            if (this.focused) {
                int n = RadialMenuScreen.this.width / 2;
                int n2 = RadialMenuScreen.this.height / 2;
                Objects.requireNonNull(RadialMenuScreen.this.font);
                int n3 = n2 - 9 / 2;
                int n4 = this.name.getLineCount() - 1;
                Objects.requireNonNull(RadialMenuScreen.this.font);
                int n5 = n3 - n4 * 9;
                Objects.requireNonNull(RadialMenuScreen.this.font);
                this.name.render(graphics, MultiLineLabel.Align.CENTER, n, n5, 9, false, -1);
            }
        }

        public boolean invoke() {
            return this.item.playAction();
        }

        public void setAction(RadialItem item) {
            this.item = item;
            this.name = MultiLineLabel.create((Font)RadialMenuScreen.this.font, (Component)item.name(), (int)((int)(RadialMenuScreen.this.radialRadius * 2.0f - 32.0f)));
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setX(float x) {
            this.x = (int)x;
            this.translateX = x - (float)this.x;
        }

        public void setY(float y) {
            this.y = (int)y;
            this.translateY = y - (float)this.y;
        }

        public boolean isFocused() {
            return this.focused;
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
            if (RadialMenuScreen.this.editMode != null && controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_PRESS.on(controller).justPressed()) {
                RadialButton button = RadialMenuScreen.this.buttons[RadialMenuScreen.this.selectedButton];
                int x = button.x < RadialMenuScreen.this.width / 2 ? button.x - 110 : button.x + 42;
                RadialMenuScreen.this.actionSelectList = new ActionSelectList(RadialMenuScreen.this.selectedButton, x, button.y, 100, 80);
                RadialMenuScreen.this.addRenderableWidget((GuiEventListener)RadialMenuScreen.this.actionSelectList);
                RadialMenuScreen.this.setFocused((GuiEventListener)RadialMenuScreen.this.actionSelectList);
                RadialMenuScreen.this.isEditing = true;
                return true;
            }
            return false;
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return this.isFocused() ? NarratableEntry.NarrationPriority.FOCUSED : NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput builder) {
            builder.add(NarratedElementType.TITLE, this.item.name());
        }

        public ScreenRectangle getRectangle() {
            return new ScreenRectangle(this.x, this.y, 32, 32);
        }
    }

    public static interface EditMode {
        public void setRadialItem(int var1, RadialItem var2);

        public List<RadialItem> getEditCandidates();
    }

    public class ActionSelectList
    implements Renderable,
    ContainerEventHandler,
    NarratableEntry,
    ComponentProcessor {
        private final int radialIndex;
        private int x;
        private int y;
        private int width;
        private int height;
        private final int itemHeight = 10;
        private int scrollOffset;
        private boolean focused;
        private ActionEntry focusedEntry;
        private final List<ActionEntry> children = new ArrayList<ActionEntry>();

        public ActionSelectList(int index, int x, int y, int width, int height) {
            this.radialIndex = index;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            for (RadialItem item : RadialMenuScreen.this.editMode.getEditCandidates()) {
                this.children.add(new ActionEntry(item));
            }
            RadialItem item = RadialMenuScreen.this.items[this.radialIndex];
            this.children.stream().filter(action -> action.item.equals(item)).findAny().ifPresent(this::setFocused);
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, Integer.MIN_VALUE);
            graphics.enableScissor(this.x, this.y, this.x + this.width, this.y + this.height);
            int y = this.y - this.scrollOffset;
            for (ActionEntry child : this.children) {
                child.render(graphics, this.x, y, this.width, 10, mouseX, mouseY, delta);
                y += 10;
            }
            graphics.disableScissor();
            graphics.submitOutline(this.x - 1, this.y - 1, this.width + 2, this.height + 2, -2130706433);
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
            if (controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
                RadialMenuScreen.this.finishEditing();
                return true;
            }
            return false;
        }

        public List<ActionEntry> children() {
            return this.children;
        }

        public boolean isDragging() {
            return false;
        }

        public void setDragging(boolean dragging) {
        }

        @Nullable
        public ActionEntry getFocused() {
            return this.focusedEntry;
        }

        public void setFocused(@Nullable GuiEventListener child) {
            int index;
            ActionEntry focus;
            this.focusedEntry = focus = (ActionEntry)child;
            if (focus != null && (index = this.children().indexOf(child)) != -1) {
                int focusY = index * 10 - this.scrollOffset;
                if (focusY < 0) {
                    this.scrollOffset = Mth.clamp((int)(index * 10), (int)0, (int)(this.children().size() * 10 - this.height));
                } else if (focusY + 10 > this.height) {
                    this.scrollOffset = Mth.clamp((int)(index * 10 + 10 - this.height), (int)0, (int)(this.children().size() * 10 - this.height));
                }
            }
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        public boolean isFocused() {
            return this.focused;
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return this.focused ? NarratableEntry.NarrationPriority.FOCUSED : NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput builder) {
            if (this.getFocused() != null) {
                builder.add(NarratedElementType.TITLE, this.getFocused().item.name());
            }
        }

        public class ActionEntry
        implements GuiEventListener,
        ComponentProcessor {
            private int x;
            private int y;
            private boolean focused;
            private final RadialItem item;

            public ActionEntry(RadialItem item) {
                this.item = item;
            }

            public void render(GuiGraphics graphics, int x, int y, int width, int itemHeight, int mouseX, int mouseY, float delta) {
                this.x = x;
                this.y = y;
                if (this.focused) {
                    graphics.fill(x, y, x + width, y + itemHeight, -16777216);
                }
                graphics.drawString(RadialMenuScreen.this.font, this.item.name(), x + 2, y + 1, this.focused ? -1 : -5855578);
            }

            public void setFocused(boolean focused) {
                this.focused = focused;
            }

            public boolean isFocused() {
                return this.focused;
            }

            @Nullable
            public ComponentPath nextFocusPath(FocusNavigationEvent event) {
                return !this.focused ? ComponentPath.leaf((GuiEventListener)this) : null;
            }

            public ScreenRectangle getRectangle() {
                return new ScreenRectangle(this.x, this.y, ActionSelectList.this.width, 10);
            }

            @Override
            public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
                if (controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_PRESS.on(controller).justPressed()) {
                    RadialMenuScreen.this.editMode.setRadialItem(ActionSelectList.this.radialIndex, this.item);
                    Controlify.instance().config().setDirty();
                    RadialMenuScreen.this.buttons[ActionSelectList.this.radialIndex].setAction(this.item);
                    RadialMenuScreen.this.playClickSound();
                    RadialMenuScreen.this.finishEditing();
                    return true;
                }
                return false;
            }
        }
    }
}

