/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.hid;

import com.google.common.primitives.Ints;
import com.mojang.datafixers.util.Pair;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.sdl.SDLNativesLoader;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ToastUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import net.minecraft.network.chat.Component;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesSpecification;
import org.hid4java.ScanMode;

public class ControllerHIDService {
    private final HidServicesSpecification specification;
    private HidServices services;
    private final Queue<Pair<HidDevice, HIDIdentifier>> unconsumedControllerHIDs;
    private final Map<String, HidDevice> attachedDevices = new HashMap<String, HidDevice>();
    private boolean disabled = false;
    private boolean firstFetch = true;
    private static final Set<Integer> CONTROLLER_USAGE_IDS = Set.of(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(8));

    public ControllerHIDService() {
        this.specification = new HidServicesSpecification();
        this.specification.setAutoStart(false);
        this.specification.setScanMode(ScanMode.NO_SCAN);
        this.unconsumedControllerHIDs = new ArrayBlockingQueue<Pair<HidDevice, HIDIdentifier>>(50);
    }

    public void start() {
        try {
            this.services = HidManager.getHidServices((HidServicesSpecification)this.specification);
            this.services.start();
        }
        catch (HidException e) {
            CUtil.LOGGER.error("Failed to start controller HID service! If you are on Linux using flatpak or snap, this is likely because your launcher has not added libusb to their package.", e);
            this.disabled = true;
        }
    }

    public void stop() {
        if (!this.disabled && this.services != null) {
            this.services.shutdown();
            this.disabled = true;
        }
    }

    public ControllerHIDInfo fetchType(int jid) {
        ControllerHIDInfo info;
        try {
            info = this.fetchType0(jid);
        }
        catch (Throwable e) {
            CUtil.LOGGER.error("Failed to fetch controller type!", e);
            info = new ControllerHIDInfo(ControllerType.DEFAULT, Optional.empty());
        }
        if (DebugProperties.PRINT_VID_PID) {
            info.hidDevice.ifPresent(hid -> {
                HexFormat hex = HexFormat.of().withPrefix("0x");
                CUtil.LOGGER.log("VID: {}, PID: {}", hex.toHexDigits(hid.vendorId()), hex.toHexDigits(hid.productId()));
            });
        }
        return info;
    }

    private ControllerHIDInfo fetchType0(int jid) {
        if (this.firstFetch) {
            this.firstFetch = false;
            if (this.isDisabled() && !SDLNativesLoader.isLoaded()) {
                ToastUtils.sendToast((Component)Component.translatable((String)"controlify.error.hid"), (Component)Component.translatable((String)"controlify.error.hid.desc"), true);
            }
        }
        if (this.disabled) {
            return new ControllerHIDInfo(ControllerType.DEFAULT, Optional.empty());
        }
        this.doScanOnThisThread();
        Pair<HidDevice, HIDIdentifier> hid = this.unconsumedControllerHIDs.poll();
        if (hid == null) {
            CUtil.LOGGER.warn("No controller found via USB hardware scan! Using SDL if available.");
            return new ControllerHIDInfo(ControllerType.DEFAULT, Optional.empty());
        }
        ControllerType type = Controlify.instance().controllerTypeManager().getControllerType((HIDIdentifier)hid.getSecond());
        this.unconsumedControllerHIDs.removeIf(h -> ((HidDevice)hid.getFirst()).getPath().equals(((HidDevice)h.getFirst()).getPath()));
        return new ControllerHIDInfo(type, Optional.of(new HIDDevice.Hid4Java((HidDevice)hid.getFirst())));
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    private void doScanOnThisThread() {
        ArrayList<String> removeList = new ArrayList<String>();
        List attachedHidDeviceList = this.services.getAttachedHidDevices();
        for (HidDevice hidDevice : attachedHidDeviceList) {
            if (this.attachedDevices.containsKey(hidDevice.getId())) continue;
            this.attachedDevices.put(hidDevice.getId(), hidDevice);
            HIDIdentifier identifier = new HIDIdentifier(hidDevice.getVendorId(), hidDevice.getProductId());
            if (!this.isController(hidDevice)) continue;
            this.unconsumedControllerHIDs.add((Pair<HidDevice, HIDIdentifier>)new Pair((Object)hidDevice, (Object)identifier));
        }
        for (Map.Entry entry : this.attachedDevices.entrySet()) {
            String deviceId = (String)entry.getKey();
            HidDevice hidDevice = (HidDevice)entry.getValue();
            if (attachedHidDeviceList.contains(hidDevice)) continue;
            removeList.add(deviceId);
            this.unconsumedControllerHIDs.removeIf(device -> this.attachedDevices.get(deviceId).getPath().equals(((HidDevice)device.getFirst()).getPath()));
        }
        if (!removeList.isEmpty()) {
            removeList.forEach(this.attachedDevices.keySet()::remove);
        }
    }

    public void unconsumeController(ControllerHIDInfo hid) {
        hid.hidDevice.ifPresent(device -> this.attachedDevices.remove(device.path()));
    }

    private boolean isController(HidDevice device) {
        boolean isControllerType = Controlify.instance().controllerTypeManager().getTypeMap().containsKey(new HIDIdentifier(device.getVendorId(), device.getProductId()));
        boolean isGenericDesktopControlOrGameControl = device.getUsagePage() == 1 || device.getUsagePage() == 5;
        boolean isSelfIdentifiedController = CONTROLLER_USAGE_IDS.contains(device.getUsage());
        return isControllerType || isGenericDesktopControlOrGameControl && isSelfIdentifiedController;
    }

    public record ControllerHIDInfo(ControllerType type, Optional<HIDDevice> hidDevice) {
        public Optional<String> createControllerUID(int controllerIndex) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            md.update(Ints.toByteArray((int)controllerIndex));
            this.hidDevice.ifPresent(hid -> {
                md.update(Ints.toByteArray((int)hid.vendorId()));
                md.update(Ints.toByteArray((int)hid.productId()));
            });
            String namespace = this.type().namespace().toString();
            if ("controlify".equals(this.type().namespace().getNamespace())) {
                namespace = this.type().namespace().getPath();
            }
            md.update(namespace.getBytes());
            return Optional.of(UUID.nameUUIDFromBytes(md.digest()).toString());
        }
    }
}

