/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.platform.main.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.platform.Environment;
import dev.isxander.controlify.platform.main.PlatformMainUtilImpl;
import dev.isxander.controlify.platform.main.events.CommandRegistrationCallbackEvent;
import dev.isxander.controlify.platform.main.events.HandshakeCompletionEvent;
import dev.isxander.controlify.platform.main.events.PlayerJoinedEvent;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoforgePlatformMainImpl
implements PlatformMainUtilImpl {
    @Override
    public void registerCommandRegistrationCallback(CommandRegistrationCallbackEvent callback) {
        NeoForge.EVENT_BUS.addListener(e -> callback.onRegister((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getBuildContext(), e.getCommandSelection()));
    }

    @Override
    public void registerInitPlayConnectionEvent(PlayerJoinedEvent event) {
        NeoForge.EVENT_BUS.addListener(e -> event.onInit((ServerPlayer)e.getEntity()));
    }

    @Override
    public boolean isModLoaded(String ... modIds) {
        return Arrays.stream(modIds).anyMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDevEnv() {
        return !FMLEnvironment.isProduction();
    }

    @Override
    public Environment getEnv() {
        return switch (FMLEnvironment.getDist()) {
            default -> throw new MatchException(null, null);
            case Dist.CLIENT -> Environment.CLIENT;
            case Dist.DEDICATED_SERVER -> Environment.SERVER;
        };
    }

    @Override
    public String getControlifyVersion() {
        return ModList.get().getModFileById("controlify").versionString();
    }

    @Override
    public void applyToControlifyEntrypoint(Consumer<ControlifyEntrypoint> entrypointConsumer) {
        ServiceLoader.load(ControlifyEntrypoint.class).forEach(entrypointConsumer);
    }

    @Override
    public <I, O> void setupServersideHandshake(ResourceLocation handshakeId, StreamCodec<FriendlyByteBuf, I> serverBoundCodec, StreamCodec<FriendlyByteBuf, O> clientBoundCodec, Supplier<O> packetCreator, HandshakeCompletionEvent<I> completionEvent) {
    }

    @Override
    public <T> Supplier<T> deferredRegister(Registry<T> registry, ResourceLocation id, Supplier<? extends T> registrant) {
        return DeferredRegister.create(registry, (String)id.getNamespace()).register(id.getPath(), registrant);
    }

    private IEventBus getModEventBus() {
        return ModLoadingContext.get().getActiveContainer().getEventBus();
    }
}

