/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.guide.ContainerCtx;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.haptic.HapticEffects;
import dev.isxander.controlify.gui.guide.GuideDomains;
import dev.isxander.controlify.gui.guide.GuideRenderer;
import dev.isxander.controlify.mixins.feature.guide.screen.AbstractContainerScreenAccessor;
import dev.isxander.controlify.mixins.feature.screenop.ScreenAccessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public class AbstractContainerScreenProcessor<T extends AbstractContainerScreen<?>>
extends ScreenProcessor<T> {
    private final GuideRenderer.Renderable guideRenderable;
    private final Supplier<Slot> hoveredSlot;
    private final ClickSlotFunction clickSlotFunction;
    private final Predicate<ControllerEntity> doItemSlotActions;

    public AbstractContainerScreenProcessor(T screen, Supplier<Slot> hoveredSlot, ClickSlotFunction clickSlotFunction, Predicate<ControllerEntity> doItemSlotActions) {
        super(screen);
        this.hoveredSlot = hoveredSlot;
        this.clickSlotFunction = clickSlotFunction;
        this.doItemSlotActions = doItemSlotActions;
        this.guideRenderable = new GuideRenderer.Renderable(GuideDomains.CONTAINER, minecraft, true, false);
    }

    @Override
    protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)this.screen;
        ContainerCtx ctx = new ContainerCtx(this.hoveredSlot.get(), ((AbstractContainerScreen)this.screen).getMenu().getCarried(), accessor.invokeHasClickedOutside(vmouse.getCurrentX(1.0f), vmouse.getCurrentY(1.0f), accessor.getLeftPos(), accessor.getTopPos()), controller, controller.genericConfig().config().guideVerbosity);
        GuideDomains.CONTAINER.updateGuides(ctx, AbstractContainerScreenProcessor.minecraft.font);
        Slot hoveredSlot = this.hoveredSlot.get();
        if (hoveredSlot != null) {
            if (hoveredSlot.hasItem() && this.doItemSlotActions.test(controller)) {
                return;
            }
            if (ControlifyBindings.INV_SELECT.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.index, 0, ClickType.PICKUP);
                this.hapticNavigate();
            }
            if (ControlifyBindings.INV_QUICK_MOVE.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.index, 0, ClickType.QUICK_MOVE);
                this.hapticNavigate();
            }
            if (ControlifyBindings.INV_TAKE_HALF.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.index, 1, ClickType.PICKUP);
                this.hapticNavigate();
            }
        } else {
            vmouse.handleCompatibilityBinds(controller);
        }
        if (!((AbstractContainerScreen)this.screen).getMenu().getCarried().isEmpty() && ControlifyBindings.DROP_INVENTORY.on(controller).justPressed()) {
            this.clickSlotFunction.clickSlot(null, -999, 0, ClickType.PICKUP);
            this.hapticNavigate();
        }
    }

    @Override
    public void onWidgetRebuild() {
        if (ControlifyApi.get().currentInputMode().isController()) {
            this.setRenderGuide(true);
        }
    }

    @Override
    public void onInputModeChanged(InputMode mode) {
        this.setRenderGuide(mode.isController());
    }

    private void setRenderGuide(boolean render) {
        List<Renderable> renderables = ((ScreenAccessor)this.screen).getRenderables();
        if (render &= ControlifyApi.get().getCurrentController().map(c -> c.genericConfig().config().showScreenGuides).orElse(false).booleanValue()) {
            renderables.add(this.guideRenderable);
        } else if (this.guideRenderable != null) {
            renderables.remove(this.guideRenderable);
        }
    }

    public void onHoveredSlotChanged(Slot newSlot, Slot oldSlot) {
        if (ControlifyApi.get().currentInputMode().isController()) {
            this.hapticNavigate();
        }
    }

    private void hapticNavigate() {
        ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::hdHaptics).ifPresent(hh -> hh.playHaptic(HapticEffects.NAVIGATE));
    }

    @Override
    public VirtualMouseBehaviour virtualMouseBehaviour() {
        return VirtualMouseBehaviour.CURSOR_ONLY;
    }

    @FunctionalInterface
    public static interface ClickSlotFunction {
        public void clickSlot(Slot var1, int var2, int var3, ClickType var4);
    }
}

