/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.server;

import dev.isxander.controlify.server.ServerPolicy;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ServerPolicies {
    REACH_AROUND("reachAround", true),
    DISABLE_FLY_DRIFTING("disableFlyDrifting", false),
    KEYBOARD_LIKE_MOVEMENT("keyboardLikeMovement", false);

    private static final Map<String, ServerPolicies> BY_ID;
    private final String id;
    private ServerPolicy value;
    private final boolean unsetValue;

    private ServerPolicies(String id, boolean unsetValue) {
        this.id = id;
        this.value = ServerPolicy.UNSET;
        this.unsetValue = unsetValue;
    }

    public boolean get() {
        return switch (this.value) {
            default -> throw new MatchException(null, null);
            case ServerPolicy.ALLOWED -> true;
            case ServerPolicy.DISALLOWED -> false;
            case ServerPolicy.UNSET -> this.unsetValue;
        };
    }

    public boolean getUnsetValue() {
        return this.unsetValue;
    }

    public boolean isUnset() {
        return this.value == ServerPolicy.UNSET;
    }

    public ServerPolicy getPolicy() {
        return this.value;
    }

    public void set(ServerPolicy value) {
        this.value = value;
    }

    public String getId() {
        return this.id;
    }

    public static ServerPolicies getById(String id) {
        return BY_ID.get(id);
    }

    public static void unsetAll() {
        for (ServerPolicies policy : ServerPolicies.values()) {
            policy.set(ServerPolicy.UNSET);
        }
    }

    static {
        BY_ID = Arrays.stream(ServerPolicies.values()).collect(Collectors.toMap(ServerPolicies::getId, e -> e));
    }
}

