/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.guide.ContainerCtx;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.haptic.HapticEffects;
import dev.isxander.controlify.gui.guide.GuideDomains;
import dev.isxander.controlify.gui.guide.GuideRenderer;
import dev.isxander.controlify.mixins.feature.guide.screen.AbstractContainerScreenAccessor;
import dev.isxander.controlify.mixins.feature.screenop.ScreenAccessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_4068;
import net.minecraft.class_465;

public class AbstractContainerScreenProcessor<T extends class_465<?>>
extends ScreenProcessor<T> {
    private final GuideRenderer.Renderable guideRenderable;
    private final Supplier<class_1735> hoveredSlot;
    private final ClickSlotFunction clickSlotFunction;
    private final Predicate<ControllerEntity> doItemSlotActions;

    public AbstractContainerScreenProcessor(T screen, Supplier<class_1735> hoveredSlot, ClickSlotFunction clickSlotFunction, Predicate<ControllerEntity> doItemSlotActions) {
        super(screen);
        this.hoveredSlot = hoveredSlot;
        this.clickSlotFunction = clickSlotFunction;
        this.doItemSlotActions = doItemSlotActions;
        this.guideRenderable = new GuideRenderer.Renderable(GuideDomains.CONTAINER, minecraft, true, false);
    }

    @Override
    protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)this.screen;
        ContainerCtx ctx = new ContainerCtx(this.hoveredSlot.get(), ((class_465)this.screen).method_17577().method_34255(), accessor.invokeHasClickedOutside(vmouse.getCurrentX(1.0f), vmouse.getCurrentY(1.0f), accessor.getLeftPos(), accessor.getTopPos(), 0), controller, controller.genericConfig().config().guideVerbosity);
        GuideDomains.CONTAINER.updateGuides(ctx, AbstractContainerScreenProcessor.minecraft.field_1772);
        class_1735 hoveredSlot = this.hoveredSlot.get();
        if (hoveredSlot != null) {
            if (hoveredSlot.method_7681() && this.doItemSlotActions.test(controller)) {
                return;
            }
            if (ControlifyBindings.INV_SELECT.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.field_7874, 0, class_1713.field_7790);
                this.hapticNavigate();
            }
            if (ControlifyBindings.INV_QUICK_MOVE.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.field_7874, 0, class_1713.field_7794);
                this.hapticNavigate();
            }
            if (ControlifyBindings.INV_TAKE_HALF.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.field_7874, 1, class_1713.field_7790);
                this.hapticNavigate();
            }
        } else {
            vmouse.handleCompatibilityBinds(controller);
        }
        if (!((class_465)this.screen).method_17577().method_34255().method_7960() && ControlifyBindings.DROP_INVENTORY.on(controller).justPressed()) {
            this.clickSlotFunction.clickSlot(null, -999, 0, class_1713.field_7790);
            this.hapticNavigate();
        }
    }

    @Override
    public void onWidgetRebuild() {
        if (ControlifyApi.get().currentInputMode().isController()) {
            this.setRenderGuide(true);
        }
    }

    @Override
    public void onInputModeChanged(InputMode mode) {
        this.setRenderGuide(mode.isController());
    }

    private void setRenderGuide(boolean render) {
        List<class_4068> renderables = ((ScreenAccessor)this.screen).getRenderables();
        if (render &= ControlifyApi.get().getCurrentController().map(c -> c.genericConfig().config().showScreenGuides).orElse(false).booleanValue()) {
            renderables.add(this.guideRenderable);
        } else if (this.guideRenderable != null) {
            renderables.remove(this.guideRenderable);
        }
    }

    public void onHoveredSlotChanged(class_1735 newSlot, class_1735 oldSlot) {
        if (ControlifyApi.get().currentInputMode().isController()) {
            this.hapticNavigate();
        }
    }

    private void hapticNavigate() {
        ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::hdHaptics).ifPresent(hh -> hh.playHaptic(HapticEffects.NAVIGATE));
    }

    @Override
    public VirtualMouseBehaviour virtualMouseBehaviour() {
        return VirtualMouseBehaviour.CURSOR_ONLY;
    }

    @FunctionalInterface
    public static interface ClickSlotFunction {
        public void clickSlot(class_1735 var1, int var2, int var3, class_1713 var4);
    }
}

