/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class RadialIcons {
    private static final Minecraft minecraft = Minecraft.getInstance();
    public static final ResourceLocation EMPTY = CUtil.rl("empty");
    public static final ResourceLocation FABRIC_ICON = ResourceLocation.fromNamespaceAndPath((String)"fabric-resource-loader-v0", (String)"icon.png");
    private static Map<ResourceLocation, RadialIcon> icons = null;
    private static Queue<Runnable> deferredRegistrations = new ArrayDeque<Runnable>();

    public static Map<ResourceLocation, RadialIcon> getIcons() {
        if (icons == null) {
            icons = RadialIcons.registerIcons();
            deferredRegistrations.forEach(Runnable::run);
            deferredRegistrations = null;
        }
        return icons;
    }

    public static void registerIcon(ResourceLocation location, RadialIcon icon) {
        if (icons == null) {
            deferredRegistrations.add(() -> RadialIcons.registerIcon(location, icon));
            return;
        }
        icons.put(location, icon);
    }

    public static ResourceLocation getItem(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).withPrefix("item/");
    }

    public static ResourceLocation getEffect(Holder<MobEffect> effect) {
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)effect.value())).withPrefix("effect/");
    }

    private static void addItems(Map<ResourceLocation, RadialIcon> map) {
        BuiltInRegistries.ITEM.entrySet().forEach(entry -> {
            ResourceKey key = (ResourceKey)entry.getKey();
            ItemStack stack = ((Item)entry.getValue()).getDefaultInstance();
            map.put(key.location().withPrefix("item/"), (graphics, x, y, tickDelta) -> graphics.renderItem(stack, x, y));
        });
    }

    private static void addPotionEffects(Map<ResourceLocation, RadialIcon> map) {
        BuiltInRegistries.MOB_EFFECT.entrySet().forEach(entry -> {
            ResourceKey key = (ResourceKey)entry.getKey();
            Holder effect = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)entry.getValue()));
            boolean render = true;
            ResourceLocation sprite = Gui.getMobEffectSprite((Holder)effect);
            if (render) {
                map.put(key.location().withPrefix("effect/"), (graphics, x, y, tickDelta) -> {
                    CGuiPose pose = CGuiPose.ofPush(graphics);
                    pose.translate(x, y);
                    pose.scale(0.88f, 0.88f);
                    Blit.sprite(graphics, sprite, 0, 0, 18, 18);
                    pose.pop();
                });
            }
        });
    }

    private static Map<ResourceLocation, RadialIcon> registerIcons() {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        map.put(EMPTY, (graphics, x, y, tickDelta) -> {});
        map.put(FABRIC_ICON, (graphics, x, y, tickDelta) -> {
            CGuiPose pose = CGuiPose.ofPush(graphics);
            pose.translate(x, y);
            pose.scale(0.5f, 0.5f);
            Blit.tex(graphics, FABRIC_ICON, 0, 0, 0, 0, 32, 32, 32, 32);
            pose.pop();
        });
        RadialIcons.addItems((Map<ResourceLocation, RadialIcon>)map);
        RadialIcons.addPotionEffects((Map<ResourceLocation, RadialIcon>)map);
        return map;
    }
}

