/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.keyboard;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.screenop.keyboard.InputTarget;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayoutWithId;
import dev.isxander.controlify.screenop.keyboard.KeyboardWidget;
import dev.isxander.controlify.utils.render.CGuiPose;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;

public class KeyboardOverlayScreen
extends Screen {
    private final Screen backgroundScreen;
    private final KeyboardLayoutWithId initialKeyboardLayout;
    private final InputTarget inputTarget;
    private final KeyboardPositioner keyboardPositioner;
    private KeyboardWidget keyboardWidget;

    public KeyboardOverlayScreen(Screen backgroundScreen, KeyboardLayoutWithId initialKeyboardLayout, InputTarget inputTarget, KeyboardPositioner keyboardPositioner) {
        super(backgroundScreen.getTitle());
        this.backgroundScreen = backgroundScreen;
        this.initialKeyboardLayout = initialKeyboardLayout;
        this.inputTarget = new WrappedInputTarget(inputTarget);
        this.keyboardPositioner = keyboardPositioner;
    }

    protected void init() {
        KeyboardLayoutWithId layout = this.keyboardWidget != null ? Controlify.instance().keyboardLayoutManager().getLayout(this.keyboardWidget.getCurrentLayoutId()) : this.initialKeyboardLayout;
        ScreenRectangle keyboardRect = this.keyboardPositioner.positionKeyboard(this.width, this.height);
        this.keyboardWidget = (KeyboardWidget)this.addRenderableWidget((GuiEventListener)new KeyboardWidget(keyboardRect.left(), keyboardRect.top(), keyboardRect.width(), keyboardRect.height(), layout, this.inputTarget));
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.backgroundScreen.resize(minecraft, width, height);
        super.resize(minecraft, width, height);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        CGuiPose pose = CGuiPose.ofPush(guiGraphics);
        this.backgroundScreen.render(guiGraphics, mouseX, mouseY, partialTick);
        pose.nextLayer(1000.0f);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.backgroundScreen.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return this.backgroundScreen.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (super.mouseClicked(x, y, button)) {
            return true;
        }
        if (this.backgroundScreen.mouseClicked(x, y, button)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public void tick() {
        this.backgroundScreen.tick();
        super.tick();
    }

    public void onClose() {
        this.minecraft.screen = this.backgroundScreen;
        Controlify.instance().virtualMouseHandler().onScreenChanged();
    }

    public static KeyboardPositioner aboveOrBelowWidgetPositioner(int desiredKeyboardWidth, int desiredKeyboardHeight, int padding, Supplier<ScreenRectangle> widgetRectSupplier) {
        return (screenWidth, screenHeight) -> {
            boolean above;
            int keyboardHeight;
            ScreenRectangle widgetRect = (ScreenRectangle)widgetRectSupplier.get();
            int keyboardWidth = Math.min(desiredKeyboardWidth, screenWidth);
            int keyboardLeft = Math.clamp((long)(widgetRect.getCenterInAxis(ScreenAxis.HORIZONTAL) - keyboardWidth / 2), 0, screenWidth - keyboardWidth);
            int spaceBelow = screenHeight - widgetRect.bottom() - padding;
            int spaceAbove = widgetRect.top() - padding;
            if (spaceBelow >= desiredKeyboardHeight) {
                keyboardHeight = desiredKeyboardHeight;
                above = false;
            } else if (spaceAbove >= desiredKeyboardHeight) {
                keyboardHeight = desiredKeyboardHeight;
                above = true;
            } else if (spaceBelow >= spaceAbove) {
                keyboardHeight = spaceBelow;
                above = false;
            } else {
                keyboardHeight = spaceAbove;
                above = true;
            }
            int keyboardTop = above ? widgetRect.top() - keyboardHeight - padding : widgetRect.bottom() + padding;
            return new ScreenRectangle(keyboardLeft, keyboardTop, keyboardWidth, keyboardHeight);
        };
    }

    private class WrappedInputTarget
    extends InputTarget.Delegated {
        public WrappedInputTarget(InputTarget target) {
            super(target);
        }

        @Override
        public boolean acceptKeyCode(int keycode, int scancode, int modifiers) {
            if (keycode == 257 || keycode == 256) {
                KeyboardOverlayScreen.this.onClose();
                return true;
            }
            return super.acceptKeyCode(keycode, scancode, modifiers);
        }
    }

    @FunctionalInterface
    public static interface KeyboardPositioner {
        public ScreenRectangle positionKeyboard(int var1, int var2);
    }
}

