/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.keyboard;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.keyboard.InputTarget;
import dev.isxander.controlify.screenop.keyboard.KeyWidget;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayout;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayoutWithId;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.render.Blit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyboardWidget
extends AbstractWidget
implements ContainerEventHandler,
ComponentProcessor {
    private ResourceLocation currentLayout;
    @Nullable
    private ResourceLocation previousLayout;
    private InputTarget inputConsumer;
    private List<KeyWidget> keys = ImmutableList.of();
    private boolean shifted;
    private boolean shiftLocked;
    @Nullable
    private KeyWidget focused;
    private boolean isDragging;
    private final HoldRepeatHelper fwdCursorHelper = new HoldRepeatHelper(10, 2);
    private final HoldRepeatHelper bwdCursorHelper = new HoldRepeatHelper(10, 2);

    public KeyboardWidget(int x, int y, int width, int height, KeyboardLayoutWithId layout, InputTarget inputConsumer) {
        super(x, y, width, height, (Component)Component.literal((String)"On-Screen Keyboard"));
        this.inputConsumer = inputConsumer;
        this.updateLayout(layout, "initial_focus", null);
    }

    public void updateLayout(KeyboardLayoutWithId layout) {
        ResourceLocation oldLayoutId = this.getCurrentLayoutId();
        @Nullable String oldIdentifier = Optional.ofNullable(this.getFocused()).map(k -> k.getKey().identifier()).orElse(null);
        this.updateLayout(layout, oldIdentifier, oldLayoutId);
    }

    public void updateLayout(KeyboardLayoutWithId layout, @Nullable String identifierToFocus, @Nullable ResourceLocation oldLayoutChangerToFocus) {
        this.previousLayout = this.currentLayout;
        this.currentLayout = layout.id();
        this.arrangeKeys(layout.layout());
        this.findKey(identifierToFocus != null, k -> Objects.equals(k.getKey().identifier(), identifierToFocus)).or(() -> this.findKey(oldLayoutChangerToFocus != null, k -> {
            KeyboardLayout.KeyFunction.SpecialFunc specialFunc;
            KeyboardLayout.KeyFunction.ChangeLayoutFunc changeLayoutKey;
            KeyboardLayout.KeyFunction keyFunction = k.getKeyFunction();
            boolean isOldLayout = keyFunction instanceof KeyboardLayout.KeyFunction.ChangeLayoutFunc && (changeLayoutKey = (KeyboardLayout.KeyFunction.ChangeLayoutFunc)keyFunction).layout().equals((Object)oldLayoutChangerToFocus);
            KeyboardLayout.KeyFunction keyFunction2 = k.getKeyFunction();
            boolean isPrevLayout = keyFunction2 instanceof KeyboardLayout.KeyFunction.SpecialFunc && (specialFunc = (KeyboardLayout.KeyFunction.SpecialFunc)keyFunction2).action() == KeyboardLayout.KeyFunction.SpecialFunc.Action.PREVIOUS_LAYOUT;
            return isOldLayout || isPrevLayout;
        }));
    }

    private void arrangeKeys(KeyboardLayout layout) {
        int keyCount = layout.keys().stream().mapToInt(List::size).sum();
        this.keys = new ArrayList<KeyWidget>(keyCount);
        float unitWidth = (float)this.getWidth() / layout.width();
        float keyHeight = (float)this.getHeight() / (float)layout.keys().size();
        int renderScale = Mth.floor((float)Math.max(0.0f, Math.min(unitWidth, keyHeight) / 60.0f)) + 1;
        float y = this.getY();
        for (List<KeyboardLayout.Key> row : layout.keys()) {
            float x = this.getX();
            for (KeyboardLayout.Key key : row) {
                float keyWidth = key.width() * unitWidth;
                KeyWidget keyWidget = new KeyWidget((int)x, (int)y, (int)keyWidth, (int)keyHeight, renderScale, key, this);
                this.keys.add(keyWidget);
                x += keyWidth;
            }
            y += keyHeight;
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (KeyWidget key : this.keys) {
            key.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        Blit.batchDraw(guiGraphics, () -> {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), Integer.MIN_VALUE);
            guiGraphics.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -5592406);
            for (KeyWidget key : this.keys) {
                key.renderKeyBackground(guiGraphics, mouseX, mouseY, partialTick);
            }
            for (KeyWidget key : this.keys) {
                key.renderKeyForeground(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
    }

    @Override
    public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
        InputTarget inputTarget = this.getInputTarget();
        GenericControllerConfig config = controller.genericConfig().config();
        if (inputTarget.supportsCursorMovement()) {
            if (this.fwdCursorHelper.shouldAction(ControlifyBindings.GUI_NEXT_TAB.on(controller)) && inputTarget.moveCursor(1)) {
                ScreenProcessor.playFocusChangeSound();
                this.fwdCursorHelper.onNavigate();
                this.bwdCursorHelper.reset();
                if (config.hintKeyboardCursor && config.showScreenGuides) {
                    config.hintKeyboardCursor = false;
                    Controlify.instance().config().save();
                }
                return true;
            }
            if (this.bwdCursorHelper.shouldAction(ControlifyBindings.GUI_PREV_TAB.on(controller)) && inputTarget.moveCursor(-1)) {
                ScreenProcessor.playFocusChangeSound();
                this.bwdCursorHelper.onNavigate();
                this.fwdCursorHelper.reset();
                if (config.hintKeyboardCursor && config.showScreenGuides) {
                    config.hintKeyboardCursor = false;
                    Controlify.instance().config().save();
                }
                return true;
            }
        }
        this.keys.forEach(k -> k.onControllerInput(controller));
        return ControlifyBindings.GUI_PRESS.on(controller).guiPressed().get();
    }

    public void setShifted(boolean shifted) {
        this.shifted = shifted;
    }

    public boolean isShifted() {
        return this.shifted;
    }

    public void setShiftLocked(boolean shiftLocked) {
        this.shiftLocked = shiftLocked;
    }

    public boolean isShiftLocked() {
        return this.shiftLocked;
    }

    public void setInputTarget(InputTarget inputConsumer) {
        this.inputConsumer = inputConsumer;
    }

    public InputTarget getInputTarget() {
        return this.inputConsumer;
    }

    public ResourceLocation getCurrentLayoutId() {
        return this.currentLayout;
    }

    public Optional<ResourceLocation> getPreviousLayoutId() {
        return Optional.ofNullable(this.previousLayout);
    }

    private Optional<KeyWidget> findKey(boolean skipSearch, Predicate<KeyWidget> predicate) {
        if (skipSearch) {
            return Optional.empty();
        }
        return this.keys.stream().filter(predicate).findFirst();
    }

    @NotNull
    public List<KeyWidget> children() {
        return Collections.unmodifiableList(this.keys);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }

    @Nullable
    public KeyWidget getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (focused != null) {
            if (!(focused instanceof KeyWidget)) {
                throw new IllegalArgumentException("Focused widget must be a KeyWidget in this KeyboardWidget");
            }
            if (!this.keys.contains(focused)) {
                focused = null;
            }
        }
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (focused != null) {
            focused.setFocused(true);
        }
        this.focused = (KeyWidget)focused;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return super.nextFocusPath(event);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean isFocused() {
        return super.isFocused();
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
    }
}

