/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.compatibility.yacl.screenop;

import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.compatibility.yacl.mixins.GroupSeparatorEntryAccessor;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.yacl3.gui.OptionListWidget;
import java.util.List;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.Nullable;

public class OptionListWidgetComponentProcessor
implements ComponentProcessor {
    private final OptionListWidget optionListWidget;

    public OptionListWidgetComponentProcessor(OptionListWidget optionListWidget) {
        this.optionListWidget = optionListWidget;
    }

    @Override
    public boolean overrideControllerNavigation(ScreenProcessor<?> screen, ControllerEntity controller) {
        OptionListWidget.GroupSeparatorEntry nextGroup;
        boolean up = ControlifyBindings.GUI_SECONDARY_NAVI_UP.on(controller).justPressed();
        boolean down = ControlifyBindings.GUI_SECONDARY_NAVI_DOWN.on(controller).justPressed();
        if ((up || down) && (nextGroup = OptionListWidgetComponentProcessor.findNextGroup(this.optionListWidget, up ? -1 : 1)) != null) {
            if (nextGroup.isExpanded()) {
                List<OptionListWidget.Entry> childEntries = ((GroupSeparatorEntryAccessor)nextGroup).getChildEntries();
                if (!childEntries.isEmpty()) {
                    OptionListWidget.Entry childEntry = childEntries.get(0);
                    GuiEventListener buttonWithinChild = (GuiEventListener)childEntry.children().get(0);
                    this.optionListWidget.setFocused((GuiEventListener)childEntries.get(0));
                    childEntry.setFocused(buttonWithinChild);
                } else {
                    this.optionListWidget.setFocused((GuiEventListener)nextGroup);
                }
            } else {
                this.optionListWidget.setFocused((GuiEventListener)nextGroup);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static OptionListWidget.GroupSeparatorEntry findNextGroup(OptionListWidget optionList, int direction) {
        List entries = optionList.children();
        OptionListWidget.Entry focusedEntry = (OptionListWidget.Entry)optionList.getFocused();
        int currentIndex = entries.indexOf(focusedEntry);
        if (direction < 0) {
            currentIndex -= 2;
        }
        if (currentIndex < 0) {
            currentIndex = 0;
        }
        for (int i = currentIndex; i >= 0 && i < entries.size(); i += direction) {
            OptionListWidget.Entry entry = (OptionListWidget.Entry)entries.get(i);
            if (!(entry instanceof OptionListWidget.GroupSeparatorEntry)) continue;
            OptionListWidget.GroupSeparatorEntry groupEntry = (OptionListWidget.GroupSeparatorEntry)entry;
            return groupEntry;
        }
        return null;
    }
}

