/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.config;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import dev.isxander.controlify.reacharound.ReachAroundMode;
import dev.isxander.controlify.server.ServerPolicies;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ServerData;

public class GlobalSettings {
    public static final GlobalSettings DEFAULT = new GlobalSettings();
    public List<Class<?>> virtualMouseScreens = Lists.newArrayList((Object[])new Class[]{AbstractContainerScreen.class});
    @SerializedName(value="keyboardMovement")
    public boolean alwaysKeyboardMovement = false;
    public List<String> keyboardMovementWhitelist = new ArrayList<String>();
    public boolean outOfFocusInput = false;
    public boolean vibrationOnboarded = false;
    public ReachAroundMode reachAround = ReachAroundMode.OFF;
    public boolean allowServerRumble = true;
    public boolean extraUiSounds = true;
    public boolean notifyLowBattery = true;
    public float ingameButtonGuideScale = 1.0f;
    public boolean useEnhancedSteamDeckDriver = true;
    public Set<String> seenServers = new HashSet<String>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldUseKeyboardMovement() {
        ServerData server = Minecraft.getInstance().getCurrentServer();
        if (this.alwaysKeyboardMovement) return true;
        if (server != null) {
            if (this.keyboardMovementWhitelist.stream().anyMatch(server.ip::endsWith)) return true;
        }
        if (!ServerPolicies.KEYBOARD_LIKE_MOVEMENT.get()) return false;
        return true;
    }
}

