/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.io.ByteStreams;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.info.ControllerInfo;
import dev.isxander.controlify.controller.info.UIDComponent;
import dev.isxander.controlify.controllermanager.AbstractControllerManager;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.ComponentAdderDriver;
import dev.isxander.controlify.driver.CompoundDriver;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.glfw.GLFWGamepadDriver;
import dev.isxander.controlify.driver.glfw.GLFWJoystickDriver;
import dev.isxander.controlify.driver.steamdeck.SteamDeckDriver;
import dev.isxander.controlify.driver.steamdeck.SteamDeckUtil;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.hid.HIDID;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

public class GLFWControllerManager
extends AbstractControllerManager {
    private boolean steamDeckConsumed = false;

    public GLFWControllerManager(ControlifyLogger logger) {
        super(logger);
        this.setupCallbacks();
    }

    private void setupCallbacks() {
        GLFW.glfwSetJoystickCallback((jid, event) -> {
            try {
                GLFWUniqueControllerID ucid = new GLFWUniqueControllerID(jid);
                if (event == 262145) {
                    this.tryCreate(ucid, this.controlify.controllerHIDService().fetchType(jid)).ifPresent(controller -> this.onControllerConnected((ControllerEntity)controller, true));
                } else if (event == 262146) {
                    this.getController(ucid).ifPresent(this::onControllerRemoved);
                }
            }
            catch (Throwable e) {
                CUtil.LOGGER.error("Failed to handle controller connect/disconnect event", e);
            }
        });
    }

    @Override
    public void discoverControllers() {
        for (int i = 0; i < 15; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            GLFWUniqueControllerID ucid = new GLFWUniqueControllerID(i);
            Optional<ControllerEntity> controllerOpt = this.tryCreate(ucid, this.controlify.controllerHIDService().fetchType(i));
            controllerOpt.ifPresent(controller -> this.onControllerConnected((ControllerEntity)controller, false));
        }
    }

    @Override
    protected Optional<ControllerEntity> createController(UniqueControllerID ucid, ControllerHIDService.ControllerHIDInfo hidInfo, ControlifyLogger controllerLogger) {
        Optional<SteamDeckDriver> steamDeckDriver;
        int jid = ((GLFWUniqueControllerID)ucid).jid;
        boolean isGamepad = this.isControllerGamepad(ucid) && !DebugProperties.FORCE_JOYSTICK;
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        if ((SteamDeckUtil.DECK_MODE.isGamingMode() || DebugProperties.STEAM_DECK_CUSTOM_CEF_URL != null) && !this.steamDeckConsumed && hidInfo.type().namespace().equals((Object)SteamDeckUtil.STEAM_DECK_NAMESPACE) && (steamDeckDriver = SteamDeckDriver.create(controllerLogger)).isPresent()) {
            drivers.add(steamDeckDriver.get());
            this.steamDeckConsumed = true;
        }
        if (isGamepad) {
            drivers.add(new GLFWGamepadDriver(jid));
        } else {
            drivers.add(new GLFWJoystickDriver(jid));
        }
        Optional<HIDID> hid = hidInfo.hidDevice().map(HIDDevice::asResourceLocation);
        String uid = hidInfo.createControllerUID(this.getControllerCountWithMatchingHID(hid.orElse(null))).orElse("unknown-uid-" + String.valueOf(ucid));
        drivers.add(new ComponentAdderDriver(controller -> controller.setComponent(new UIDComponent(uid))));
        CompoundDriver compoundDriver = new CompoundDriver(drivers);
        ControllerInfo info = new ControllerInfo(ucid, hidInfo.type(), hidInfo.hidDevice());
        ControllerEntity controller2 = new ControllerEntity(info, compoundDriver, controllerLogger);
        this.addController(ucid, controller2);
        return Optional.of(controller2);
    }

    @Override
    public boolean probeConnectedControllers() {
        return GLFWControllerManager.areControllersConnected();
    }

    @Override
    protected void loadGamepadMappings(ResourceProvider resourceProvider) {
        CUtil.LOGGER.debugLog("Loading gamepad mappings...");
        Optional resourceOpt = resourceProvider.getResource(CUtil.rl("controllers/gamecontrollerdb-sdl2.txt"));
        if (resourceOpt.isEmpty()) {
            CUtil.LOGGER.error("Failed to find game controller database.");
            return;
        }
        try (InputStream is = ((Resource)resourceOpt.get()).open();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
            ByteBuffer buffer = MemoryUtil.memASCIISafe((CharSequence)new String(bytes));
            if (!GLFW.glfwUpdateGamepadMappings((ByteBuffer)buffer)) {
                CUtil.LOGGER.error("Failed to load gamepad mappings: {}", GLFW.glfwGetError(null));
            }
        }
        catch (Throwable e) {
            CUtil.LOGGER.error("Failed to load gamepad mappings: {}", e.getMessage());
        }
    }

    private Optional<ControllerEntity> getController(GLFWUniqueControllerID joystickId) {
        return this.controllersByUid.values().stream().filter(controller -> controller.info().ucid().equals(joystickId)).findAny();
    }

    @Override
    public boolean isControllerGamepad(UniqueControllerID ucid) {
        int joystickId = ((GLFWUniqueControllerID)ucid).jid;
        return GLFW.glfwJoystickIsGamepad((int)joystickId);
    }

    @Override
    protected String getControllerSystemName(UniqueControllerID ucid) {
        int joystickId = ((GLFWUniqueControllerID)ucid).jid;
        return this.isControllerGamepad(ucid) ? GLFW.glfwGetGamepadName((int)joystickId) : GLFW.glfwGetJoystickName((int)joystickId);
    }

    public static boolean areControllersConnected() {
        return IntStream.range(0, 16).anyMatch(GLFW::glfwJoystickPresent);
    }

    public record GLFWUniqueControllerID(int jid) implements UniqueControllerID
    {
    }
}

