/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.ingame.DualInput;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.Nullable;

public class ControllerPlayerMovement
extends Input {
    private final ControllerEntity controller;
    private final LocalPlayer player;
    private boolean wasFlying;
    private boolean wasPassenger;

    public ControllerPlayerMovement(ControllerEntity controller, LocalPlayer player) {
        this.controller = controller;
        this.player = player;
    }

    public void tick(boolean slowDown, float movementMultiplier) {
        if (Minecraft.getInstance().screen != null || this.player == null) {
            this.setMoveVec(0.0f, 0.0f);
            this.up = false;
            this.down = false;
            this.left = false;
            this.right = false;
            this.jumping = false;
            this.shiftKeyDown = false;
            return;
        }
        float forwardImpulse = ControlifyBindings.WALK_FORWARD.on(this.controller).analogueNow() - ControlifyBindings.WALK_BACKWARD.on(this.controller).analogueNow();
        float leftImpulse = ControlifyBindings.WALK_LEFT.on(this.controller).analogueNow() - ControlifyBindings.WALK_RIGHT.on(this.controller).analogueNow();
        if (Controlify.instance().config().globalSettings().shouldUseKeyboardMovement()) {
            float threshold = ((InputComponent.Config)this.controller.input().orElseThrow().confObj()).buttonActivationThreshold;
            forwardImpulse = Math.abs(forwardImpulse) >= threshold ? Math.copySign(1.0f, forwardImpulse) : 0.0f;
            leftImpulse = Math.abs(leftImpulse) >= threshold ? Math.copySign(1.0f, leftImpulse) : 0.0f;
        }
        this.up = forwardImpulse > 0.0f;
        this.down = forwardImpulse < 0.0f;
        this.left = leftImpulse > 0.0f;
        boolean bl = this.right = leftImpulse < 0.0f;
        if (slowDown) {
            leftImpulse *= movementMultiplier;
            forwardImpulse *= movementMultiplier;
        }
        this.setMoveVec(forwardImpulse, leftImpulse);
        InputBinding jump = ControlifyBindings.JUMP.on(this.controller);
        if (jump.justPressed()) {
            this.jumping = true;
        }
        if (!jump.digitalNow()) {
            this.jumping = false;
        }
        InputBinding sneak = ControlifyBindings.SNEAK.on(this.controller);
        if (this.player.getAbilities().flying || this.player.isInWater() && !this.player.onGround() || this.player.getVehicle() != null || !this.controller.genericConfig().config().toggleSneak) {
            if (sneak.justPressed()) {
                this.shiftKeyDown = true;
            }
            if (!sneak.digitalNow()) {
                this.shiftKeyDown = false;
            }
        } else if (sneak.justPressed()) {
            boolean bl2 = this.shiftKeyDown = !this.shiftKeyDown;
        }
        if (!this.player.getAbilities().flying && this.wasFlying && this.player.onGround() || !this.player.isPassenger() && this.wasPassenger) {
            this.shiftKeyDown = false;
        }
        this.wasFlying = this.player.getAbilities().flying;
        this.wasPassenger = this.player.isPassenger();
    }

    private void setMoveVec(float forward, float left) {
        this.forwardImpulse = forward;
        this.leftImpulse = left;
    }

    public static void updatePlayerInput(@Nullable LocalPlayer player) {
        if (player == null) {
            return;
        }
        if (ControllerPlayerMovement.shouldBeControllerInput()) {
            player.input = new DualInput((Input)new KeyboardInput(Minecraft.getInstance().options), new ControllerPlayerMovement(Controlify.instance().getCurrentController().get(), player));
        } else if (!(player.input instanceof KeyboardInput)) {
            player.input = new KeyboardInput(Minecraft.getInstance().options);
        }
    }

    public static void ensureCorrectInput(@Nullable LocalPlayer player) {
        if (player == null) {
            return;
        }
        if (ControllerPlayerMovement.shouldBeControllerInput() && player.input.getClass() == KeyboardInput.class) {
            ControllerPlayerMovement.updatePlayerInput(player);
        }
    }

    public static boolean shouldBeControllerInput() {
        return Controlify.instance().getCurrentController().isPresent() && Controlify.instance().currentInputMode().isController();
    }
}

