/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.guide.screen;

import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.gui.ButtonGuideRenderer;
import dev.isxander.controlify.mixins.feature.guide.screen.AbstractWidgetMixin;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractButton.class})
public abstract class AbstractButtonMixin
extends AbstractWidgetMixin
implements ButtonGuideRenderer<AbstractButton> {
    @Unique
    private ButtonGuideRenderer.RenderData<AbstractButton> renderData = null;
    @Unique
    private final Map<InputBinding, Component> controllerMessages = new Object2ObjectArrayMap(2);

    @Override
    protected Component modifyRenderedLabel(Component originalMessage) {
        return this.getControllerMessage(originalMessage);
    }

    @Override
    protected void catchMessageSet(Component message, CallbackInfo ci) {
        this.controllerMessages.clear();
    }

    @Override
    public void controlify$setButtonGuide(ButtonGuideRenderer.RenderData<AbstractButton> renderData) {
        this.renderData = renderData;
        this.controllerMessages.clear();
    }

    @Unique
    private Component getControllerMessage(Component actualLabel) {
        if (!this.shouldRender()) {
            return actualLabel;
        }
        return this.getBind().map(bind -> this.controllerMessages.computeIfAbsent((InputBinding)bind, b -> this.renderData.getControllerMessage((InputBinding)b, actualLabel))).orElse(actualLabel);
    }

    @Unique
    protected boolean shouldRender() {
        return this.renderData != null && this.isActive() && this.renderData.shouldRender((AbstractButton)this);
    }

    @Unique
    private Optional<InputBinding> getBind() {
        if (this.renderData == null) {
            return Optional.empty();
        }
        return this.renderData.getBind();
    }
}

