/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.screenop.impl.chat;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.controlify.screenop.keyboard.ChatKeyboardDucky;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ChatComponent.class})
public abstract class ChatComponentMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private static final int VANILLA_CHAT_PADDING = 40;
    @Unique
    private static final int SHIFTED_CHAT_PADDING = 20;
    @Unique
    private static final String RENDER_METHOD = "render";

    @Shadow
    public abstract double getScale();

    @ModifyExpressionValue(method={"render"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="floor", method={"Lnet/minecraft/util/Mth;floor(F)I"})
    @Expression(value={"floor((float) (@(?) - 40) / ?)"})
    private int modifyChatOffset(int y) {
        Screen screen = this.minecraft.screen;
        if (screen instanceof ChatScreen) {
            ChatScreen chat = (ChatScreen)screen;
            return (int)((float)y * (1.0f - ChatKeyboardDucky.getKeyboardShiftAmount(chat)));
        }
        return y;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="CONSTANT", args={"intValue=40"})})
    private int modifyChatToInputPadding(int padding) {
        ChatScreen chat;
        Screen screen = this.minecraft.screen;
        if (screen instanceof ChatScreen && ChatKeyboardDucky.getKeyboardShiftAmount(chat = (ChatScreen)screen) > 0.0f) {
            return 20;
        }
        return padding;
    }

    @ModifyVariable(method={"screenToChatY"}, at=@At(value="HEAD"), argsOnly=true)
    private double modifyScreenY(double y) {
        ChatScreen chat;
        float shiftAmount;
        Screen screen = this.minecraft.screen;
        if (screen instanceof ChatScreen && (shiftAmount = ChatKeyboardDucky.getKeyboardShiftAmount(chat = (ChatScreen)screen)) > 0.0f) {
            double shiftPixels = shiftAmount * (float)this.minecraft.getWindow().getGuiScaledHeight() - 20.0f;
            return y + shiftPixels;
        }
        return y;
    }
}

