/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.platform.client.neoforge;

import dev.isxander.controlify.platform.client.CreativeTabHelper;
import dev.isxander.controlify.platform.client.HudRenderLayer;
import dev.isxander.controlify.platform.client.PlatformClientUtilImpl;
import dev.isxander.controlify.platform.client.events.DisconnectedEvent;
import dev.isxander.controlify.platform.client.events.LifecycleEvent;
import dev.isxander.controlify.platform.client.events.ScreenRenderEvent;
import dev.isxander.controlify.platform.client.events.TickEvent;
import dev.isxander.controlify.platform.client.neoforge.NeoforgeCreativeTabHelper;
import dev.isxander.controlify.platform.client.resource.ControlifyReloadListener;
import dev.isxander.controlify.platform.neoforge.VanillaKeyMappingHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class NeoforgePlatformClientImpl
implements PlatformClientUtilImpl {
    @Nullable
    private Collection<KeyMapping> moddedKeyMappings;

    @Override
    public void registerClientTickStarted(TickEvent event) {
        NeoForge.EVENT_BUS.addListener(e -> event.onTick(Minecraft.getInstance()));
    }

    @Override
    public void registerClientTickEnded(TickEvent event) {
        NeoForge.EVENT_BUS.addListener(e -> event.onTick(Minecraft.getInstance()));
    }

    @Override
    public void registerClientStopping(LifecycleEvent event) {
        NeoForge.EVENT_BUS.addListener(e -> event.onLifecycle(Minecraft.getInstance()));
    }

    @Override
    public void registerClientDisconnected(DisconnectedEvent event) {
        NeoForge.EVENT_BUS.addListener(e -> event.onDisconnected(Minecraft.getInstance()));
    }

    @Override
    public void registerAssetReloadListener(ControlifyReloadListener reloadListener) {
        this.getModEventBus().addListener(e -> e.registerReloadListener((PreparableReloadListener)reloadListener));
    }

    @Override
    public void registerBuiltinResourcePack(ResourceLocation id, Component displayName) {
        ResourceLocation packLocation = id.withPrefix("resourcepacks/");
        this.getModEventBus().addListener(e -> e.addPackFinders(packLocation, PackType.CLIENT_RESOURCES, displayName, PackSource.BUILT_IN, false, Pack.Position.TOP));
    }

    @Override
    public void addHudLayer(ResourceLocation id, HudRenderLayer renderLayer) {
        this.getModEventBus().addListener(RegisterGuiLayersEvent.class, e -> e.registerAboveAll(id, renderLayer::render));
    }

    @Override
    public void registerPostScreenRender(ScreenRenderEvent event) {
        NeoForge.EVENT_BUS.addListener(e -> event.onRender(e.getScreen(), e.getGuiGraphics(), e.getMouseX(), e.getMouseY(), e.getPartialTick()));
    }

    @Override
    public Collection<KeyMapping> getModdedKeyMappings() {
        if (this.moddedKeyMappings == null) {
            this.moddedKeyMappings = this.calculateModdedKeyMappings();
        }
        return this.moddedKeyMappings;
    }

    private Collection<KeyMapping> calculateModdedKeyMappings() {
        Options options = Minecraft.getInstance().options;
        KeyMapping[] vanillaAndModded = options.keyMappings;
        List<KeyMapping> vanillaOnly = Arrays.asList(((VanillaKeyMappingHolder)options).controlify$getVanillaKeys());
        return Arrays.stream(vanillaAndModded).filter(key -> !vanillaOnly.contains(key)).toList();
    }

    @Override
    public <I, O> void setupClientsideHandshake(ResourceLocation handshakeId, StreamCodec<FriendlyByteBuf, I> clientBoundCodec, StreamCodec<FriendlyByteBuf, O> serverBoundCodec, Function<I, O> handshakeHandler) {
    }

    @Override
    public CreativeTabHelper createCreativeTabHelper(CreativeModeInventoryScreen creativeScreen) {
        return new NeoforgeCreativeTabHelper(creativeScreen);
    }

    private IEventBus getModEventBus() {
        return ModLoadingContext.get().getActiveContainer().getEventBus();
    }
}

