/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.reacharound;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.reacharound.ReachAroundMode;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.server.ServerPolicy;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ReachAroundHandler {
    public static HitResult getReachAroundHitResult(Entity entity, HitResult hitResult) {
        if (hitResult.getType() != HitResult.Type.MISS) {
            return hitResult;
        }
        if (!ReachAroundHandler.canReachAround(entity)) {
            return hitResult;
        }
        BlockPos supportingBlockPos = entity.getOnPos();
        if (entity.level().getBlockState(supportingBlockPos).isAir()) {
            return hitResult;
        }
        return new BlockHitResult(supportingBlockPos.getCenter(), entity.getDirection(), supportingBlockPos, false);
    }

    private static boolean canReachAround(Entity cameraEntity) {
        boolean serverAllowed = switch (ServerPolicies.REACH_AROUND.getPolicy()) {
            default -> throw new MatchException(null, null);
            case ServerPolicy.DISALLOWED -> false;
            case ServerPolicy.UNSET -> Controlify.instance().config().globalSettings().reachAround.canReachAround();
            case ServerPolicy.ALLOWED -> Controlify.instance().config().globalSettings().reachAround != ReachAroundMode.OFF;
        };
        return serverAllowed && cameraEntity.getVehicle() == null && cameraEntity.getXRot() >= 45.0f && cameraEntity.onGround();
    }
}

