/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.haptic.HapticEffects;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.mixins.feature.screenop.ScreenAccessor;
import dev.isxander.controlify.mixins.feature.screenop.impl.outofgame.TabNavigationBarAccessor;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ComponentProcessorProvider;
import dev.isxander.controlify.screenop.CustomFocus;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.keyboard.ComponentKeyboardBehaviour;
import dev.isxander.controlify.screenop.keyboard.InputTarget;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayoutWithId;
import dev.isxander.controlify.screenop.keyboard.KeyboardOverlayScreen;
import dev.isxander.controlify.sound.ControlifyClientSounds;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public class ScreenProcessor<T extends Screen> {
    public final T screen;
    protected final HoldRepeatHelper holdRepeatHelper;
    protected static final Minecraft minecraft = Minecraft.getInstance();
    private final List<ScreenControllerEventListener> eventListeners = new ArrayList<ScreenControllerEventListener>();

    public ScreenProcessor(T screen) {
        this.screen = screen;
        if (screen instanceof ScreenControllerEventListener) {
            ScreenControllerEventListener eventListener = (ScreenControllerEventListener)screen;
            this.eventListeners.add(eventListener);
        }
        this.holdRepeatHelper = this.createHoldRepeatHelper();
    }

    public void onControllerUpdate(ControllerEntity controller) {
        Controlify.instance().virtualMouseHandler().handleControllerInput(controller);
        if (!Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled()) {
            if (!this.handleComponentNavOverride(controller)) {
                this.handleComponentNavigation(controller);
            }
            if (!this.handleComponentButtonOverride(controller)) {
                this.handleButtons(controller);
            }
        } else {
            this.handleScreenVMouse(controller, Controlify.instance().virtualMouseHandler());
        }
        this.handleTabNavigation(controller);
        this.eventListeners.forEach(listener -> listener.onControllerInput(controller));
    }

    public void render(ControllerEntity controller, GuiGraphics graphics, float tickDelta) {
        VirtualMouseHandler vmouse = Controlify.instance().virtualMouseHandler();
        this.render(controller, graphics, tickDelta, vmouse.isVirtualMouseEnabled() ? Optional.of(vmouse) : Optional.empty());
    }

    public void onInputModeChanged(InputMode mode) {
        switch (mode) {
            case KEYBOARD_MOUSE: {
                boolean shouldKeepFocus = this.getFocusTree().stream().anyMatch(component -> ComponentProcessorProvider.provide(component).shouldKeepFocusOnKeyboardMode(this));
                if (shouldKeepFocus) break;
                ((ScreenAccessor)this.screen).invokeClearFocus();
                break;
            }
            case CONTROLLER: 
            case MIXED: {
                if (Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled()) break;
                this.setInitialFocus();
            }
        }
    }

    protected void handleComponentNavigation(ControllerEntity controller) {
        ComponentPath path;
        if (this.screen.getFocused() == null) {
            this.setInitialFocus();
        }
        List<GuiEventListener> focuses = List.copyOf(this.getFocusTree());
        ScreenAccessor accessor = (ScreenAccessor)this.screen;
        boolean repeatEventAvailable = this.holdRepeatHelper.canNavigate();
        InputComponent input = controller.input().orElseThrow();
        ControllerStateView state = input.stateNow();
        ControllerStateView prevState = input.stateThen();
        InputBinding guiNaviRight = ControlifyBindings.GUI_NAVI_RIGHT.on(controller);
        InputBinding guiNaviLeft = ControlifyBindings.GUI_NAVI_LEFT.on(controller);
        InputBinding guiNaviUp = ControlifyBindings.GUI_NAVI_UP.on(controller);
        InputBinding guiNaviDown = ControlifyBindings.GUI_NAVI_DOWN.on(controller);
        FocusNavigationEvent.ArrowNavigation event = null;
        if (guiNaviRight.digitalNow() && (repeatEventAvailable || !guiNaviRight.digitalPrev())) {
            event = accessor.invokeCreateArrowEvent(ScreenDirection.RIGHT);
            if (!guiNaviRight.digitalPrev()) {
                this.holdRepeatHelper.reset();
            }
        } else if (guiNaviLeft.digitalNow() && (repeatEventAvailable || !guiNaviLeft.digitalPrev())) {
            event = accessor.invokeCreateArrowEvent(ScreenDirection.LEFT);
            if (!guiNaviLeft.digitalPrev()) {
                this.holdRepeatHelper.reset();
            }
        } else if (guiNaviUp.digitalNow() && (repeatEventAvailable || !guiNaviUp.digitalPrev())) {
            event = accessor.invokeCreateArrowEvent(ScreenDirection.UP);
            if (!guiNaviUp.digitalPrev()) {
                this.holdRepeatHelper.reset();
            }
        } else if (guiNaviDown.digitalNow() && (repeatEventAvailable || !guiNaviDown.digitalPrev())) {
            event = accessor.invokeCreateArrowEvent(ScreenDirection.DOWN);
            if (!guiNaviDown.digitalPrev()) {
                this.holdRepeatHelper.reset();
            }
        } else if (state.isButtonDown(GamepadInputs.DPAD_RIGHT_BUTTON) && (repeatEventAvailable || !prevState.isButtonDown(GamepadInputs.DPAD_RIGHT_BUTTON))) {
            event = accessor.invokeCreateArrowEvent(ScreenDirection.RIGHT);
            if (!prevState.isButtonDown(GamepadInputs.DPAD_RIGHT_BUTTON)) {
                this.holdRepeatHelper.reset();
            }
        } else if (state.isButtonDown(GamepadInputs.DPAD_LEFT_BUTTON) && (repeatEventAvailable || !prevState.isButtonDown(GamepadInputs.DPAD_LEFT_BUTTON))) {
            event = accessor.invokeCreateArrowEvent(ScreenDirection.LEFT);
            if (!prevState.isButtonDown(GamepadInputs.DPAD_LEFT_BUTTON)) {
                this.holdRepeatHelper.reset();
            }
        } else if (state.isButtonDown(GamepadInputs.DPAD_UP_BUTTON) && (repeatEventAvailable || !prevState.isButtonDown(GamepadInputs.DPAD_UP_BUTTON))) {
            event = accessor.invokeCreateArrowEvent(ScreenDirection.UP);
            if (!prevState.isButtonDown(GamepadInputs.DPAD_UP_BUTTON)) {
                this.holdRepeatHelper.reset();
            }
        } else if (state.isButtonDown(GamepadInputs.DPAD_DOWN_BUTTON) && (repeatEventAvailable || !prevState.isButtonDown(GamepadInputs.DPAD_DOWN_BUTTON))) {
            event = accessor.invokeCreateArrowEvent(ScreenDirection.DOWN);
            if (!prevState.isButtonDown(GamepadInputs.DPAD_DOWN_BUTTON)) {
                this.holdRepeatHelper.reset();
            }
        }
        if (event != null && (path = this.screen.nextFocusPath((FocusNavigationEvent)event)) != null) {
            accessor.invokeChangeFocus(path);
            this.holdRepeatHelper.onNavigate();
            controller.input().ifPresent(InputComponent::notifyGuiPressOutputsOfNavigate);
            if (Controlify.instance().config().globalSettings().extraUiSounds) {
                ScreenProcessor.playFocusChangeSound();
            }
            controller.hdHaptics().ifPresent(haptics -> haptics.playHaptic(HapticEffects.NAVIGATE));
            Queue<GuiEventListener> newFocusTree = this.getFocusTree();
            while (!newFocusTree.isEmpty() && !focuses.contains(newFocusTree.peek())) {
                ComponentProcessorProvider.provide(newFocusTree.poll()).onFocusGained(this, controller);
            }
        }
    }

    protected void handleButtons(ControllerEntity controller) {
        boolean vmouseEnabled = Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled();
        InputComponent input = controller.input().orElseThrow();
        boolean touchpadPressed = input.stateNow().isButtonDown(GamepadInputs.TOUCHPAD_1_BUTTON);
        boolean prevTouchpadPressed = input.stateThen().isButtonDown(GamepadInputs.TOUCHPAD_1_BUTTON);
        if ((ControlifyBindings.GUI_PRESS.on(controller).guiPressed().get() || vmouseEnabled && touchpadPressed && !prevTouchpadPressed) && !this.tryOpenKeyboard(controller, this.screen.getFocused())) {
            this.screen.keyPressed(257, 0, 0);
        }
        if (this.screen.shouldCloseOnEsc() && ControlifyBindings.GUI_BACK.on(controller).guiPressed().get()) {
            ScreenProcessor.playClackSound();
            this.screen.onClose();
        }
    }

    protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
        Minecraft.getInstance().setLastInputType(InputType.MOUSE);
    }

    protected boolean handleComponentButtonOverride(ControllerEntity controller) {
        Queue<GuiEventListener> focusTree = this.getFocusTree();
        while (!focusTree.isEmpty()) {
            GuiEventListener focused = focusTree.poll();
            ComponentProcessor processor = ComponentProcessorProvider.provide(focused);
            if (!processor.overrideControllerButtons(this, controller)) continue;
            return true;
        }
        return false;
    }

    protected boolean handleComponentNavOverride(ControllerEntity controller) {
        Queue<GuiEventListener> focusTree = this.getFocusTree();
        while (!focusTree.isEmpty()) {
            GuiEventListener focused = focusTree.poll();
            ComponentProcessor processor = ComponentProcessorProvider.provide(focused);
            if (!processor.overrideControllerNavigation(this, controller)) continue;
            return true;
        }
        return false;
    }

    protected void handleTabNavigation(ControllerEntity controller) {
        block3: {
            boolean prevTab;
            block2: {
                boolean nextTab = ControlifyBindings.GUI_NEXT_TAB.on(controller).justPressed();
                prevTab = ControlifyBindings.GUI_PREV_TAB.on(controller).justPressed();
                if (nextTab) break block2;
                if (!prevTab) break block3;
            }
            this.screen.children().stream().filter(child -> child instanceof TabNavigationBar).map(TabNavigationBar.class::cast).findAny().ifPresent(navBar -> {
                TabNavigationBarAccessor accessor = (TabNavigationBarAccessor)navBar;
                ImmutableList<Tab> tabs = accessor.getTabs();
                int currentIndex = tabs.indexOf(accessor.getTabManager().getCurrentTab());
                int newIndex = currentIndex + (prevTab ? -1 : 1);
                if (newIndex < 0) {
                    newIndex = tabs.size() - 1;
                }
                if (newIndex >= tabs.size()) {
                    newIndex = 0;
                }
                navBar.selectTab(newIndex, true);
                this.onTabChanged(controller);
            });
        }
    }

    protected void onTabChanged(ControllerEntity controller) {
    }

    public void onWidgetRebuild() {
        this.setInitialFocus();
        this.updateLastInputTypeOnRebild();
    }

    private void updateLastInputTypeOnRebild() {
        VirtualMouseHandler virtualMouseBehaviour = Controlify.instance().virtualMouseHandler();
        if (virtualMouseBehaviour != null && !virtualMouseBehaviour.isVirtualMouseEnabled()) {
            Minecraft.getInstance().setLastInputType(InputType.KEYBOARD_ARROW);
        }
    }

    public void onVirtualMouseToggled(boolean enabled) {
        if (enabled) {
            ((ScreenAccessor)this.screen).invokeClearFocus();
        } else {
            this.setInitialFocus();
        }
    }

    protected void render(ControllerEntity controller, GuiGraphics graphics, float tickDelta, Optional<VirtualMouseHandler> vmouse) {
    }

    protected void setInitialFocus() {
        ScreenAccessor accessor;
        ComponentPath path;
        if (this.screen.getFocused() == null && Controlify.instance().currentInputMode().isController() && !Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled() && (path = this.screen.nextFocusPath((FocusNavigationEvent)(accessor = (ScreenAccessor)this.screen).invokeCreateArrowEvent(ScreenDirection.DOWN))) != null) {
            accessor.invokeChangeFocus(path);
            this.holdRepeatHelper.clearDelay();
        }
    }

    public VirtualMouseBehaviour virtualMouseBehaviour() {
        return VirtualMouseBehaviour.DEFAULT;
    }

    public void addEventListener(ScreenControllerEventListener listener) {
        this.eventListeners.add(listener);
    }

    public boolean tryOpenKeyboard(ControllerEntity controller, @Nullable GuiEventListener element) {
        block9: {
            KeyboardLayoutWithId layout;
            Object object;
            ComponentKeyboardBehaviour behaviour;
            ComponentProcessor componentProcessor = ComponentProcessorProvider.provide(element);
            ComponentKeyboardBehaviour componentKeyboardBehaviour = behaviour = componentProcessor.getKeyboardBehaviour(this, controller);
            Objects.requireNonNull(componentKeyboardBehaviour);
            ComponentKeyboardBehaviour componentKeyboardBehaviour2 = componentKeyboardBehaviour;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComponentKeyboardBehaviour.DoNothing.class, ComponentKeyboardBehaviour.Undefined.class, ComponentKeyboardBehaviour.Handled.class}, (Object)componentKeyboardBehaviour2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ComponentKeyboardBehaviour.DoNothing doNothing = (ComponentKeyboardBehaviour.DoNothing)componentKeyboardBehaviour2;
                    return true;
                }
                case 1: {
                    ComponentKeyboardBehaviour.Undefined undefined = (ComponentKeyboardBehaviour.Undefined)componentKeyboardBehaviour2;
                    return false;
                }
                case 2: 
            }
            ComponentKeyboardBehaviour.Handled handled = (ComponentKeyboardBehaviour.Handled)componentKeyboardBehaviour2;
            try {
                object = handled.layout();
                layout = object;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object inputTarget = object = handled.inputTarget();
            Object positioner = object = handled.positioner();
            if (!controller.genericConfig().config().showOnScreenKeyboard) break block9;
            minecraft.setScreen((Screen)new KeyboardOverlayScreen((Screen)this.screen, layout, (InputTarget)inputTarget, (KeyboardOverlayScreen.KeyboardPositioner)positioner));
        }
        return true;
    }

    protected HoldRepeatHelper createHoldRepeatHelper() {
        return new HoldRepeatHelper(10, 3);
    }

    protected Queue<GuiEventListener> getFocusTree() {
        if (this.screen.getFocused() == null) {
            return new ArrayDeque<GuiEventListener>();
        }
        ArrayDeque<GuiEventListener> tree = new ArrayDeque<GuiEventListener>();
        GuiEventListener focused = this.screen.getFocused();
        tree.add(focused);
        while (focused instanceof CustomFocus) {
            CustomFocus customFocus = (CustomFocus)focused;
            if ((focused = customFocus.getCustomFocus()) == null) continue;
            tree.addFirst(focused);
        }
        return tree;
    }

    protected final Optional<AbstractWidget> getWidget(Component message) {
        return this.screen.children().stream().filter(child -> child instanceof AbstractWidget).map(AbstractWidget.class::cast).filter(widget -> widget.getMessage().equals((Object)message)).findAny();
    }

    protected final Optional<AbstractWidget> getWidget(String translationKey) {
        String translatedName = Component.translatable((String)translationKey).getString();
        return this.screen.children().stream().filter(child -> child instanceof AbstractWidget).map(AbstractWidget.class::cast).filter(widget -> widget.getMessage().getString().equals(translatedName)).findAny();
    }

    public static void playClackSound() {
        minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public static void playFocusChangeSound() {
        minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)ControlifyClientSounds.SCREEN_FOCUS_CHANGE.get(), (float)1.0f));
    }
}

