/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop;

import dev.isxander.controlify.screenop.ScreenProcessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;

public final class ScreenProcessorFactory {
    private static final Map<Class<? extends Screen>, Factory<?>> factories = new Object2ObjectOpenHashMap();

    private ScreenProcessorFactory() {
    }

    public static <T extends Screen> ScreenProcessor<? super T> createForScreen(T screen) {
        Class<?> screenClass;
        for (screenClass = screen.getClass(); !factories.containsKey(screenClass) && screenClass != Screen.class; screenClass = screenClass.getSuperclass()) {
        }
        return (ScreenProcessor)factories.getOrDefault(screenClass, ScreenProcessorFactory::createDefault).apply(screen);
    }

    public static <T extends Screen> void registerProvider(Class<T> screenClass, Factory<T> factory) {
        factories.put(screenClass, factory);
    }

    private static <T extends Screen> ScreenProcessor<T> createDefault(T screen) {
        return new ScreenProcessor<T>(screen);
    }

    public static interface Factory<T extends Screen>
    extends Function<T, ScreenProcessor<? super T>> {
    }
}

