/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import dev.isxander.controlify.utils.render.Blit;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public final class ClientUtils {
    private static final ResourceLocation GREEN_BACK_BAR = ResourceLocation.withDefaultNamespace((String)"boss_bar/green_background");
    private static final ResourceLocation GREEN_FRONT_BAR = ResourceLocation.withDefaultNamespace((String)"boss_bar/green_progress");

    private ClientUtils() {
    }

    public static StringWidget createStringWidget(Component text, Font font, int x, int y) {
        int n = font.width(text.getVisualOrderText());
        Objects.requireNonNull(font);
        return new StringWidget(x, y, n, 9, text, font);
    }

    public static PlainTextButton createPlainTextButton(Component text, Font font, int x, int y, Button.OnPress onPress) {
        int n = font.width(text.getVisualOrderText());
        Objects.requireNonNull(font);
        return new PlainTextButton(x, y, n, 9, text, onPress, font);
    }

    public static void drawSprite(GuiGraphics graphics, ResourceLocation location, int x, int y, int width, int height) {
        Blit.sprite(graphics, location, x, y, width, height);
    }

    public static void drawBar(GuiGraphics graphics, int centerX, int y, float progress) {
        int width = Mth.lerpDiscrete((float)progress, (int)0, (int)182);
        int x = centerX - 91;
        Blit.sprite(graphics, GREEN_BACK_BAR, 182, 5, 0, 0, x, y, 182, 5);
        if (width > 0) {
            Blit.sprite(graphics, GREEN_FRONT_BAR, 182, 5, 0, 0, x, y, width, 5);
        }
    }
}

